﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

using System.DirectoryServices;
using de.ITVisions.DemoViewer;
using System.DirectoryServices.ActiveDirectory;

namespace NET2.FCL
{

 [Demo]
 public class ActiveDirectory
	{

  [AutoRun]
		public void DomänenInfos()
		{
			// Aktuelle Domain ermitteln
			Domain d = System.DirectoryServices.ActiveDirectory.Domain.GetCurrentDomain();
			
   // Informationen über aktuelle Domäne
			Console.WriteLine("Name: " + d.Name);
			Console.WriteLine("Domain Mode: " + d.DomainMode);
			Console.WriteLine("Inhaber der InfrastructureRole: " + d.InfrastructureRoleOwner.Name);
   Console.WriteLine("Inhaber der PdcRole: " + d.PdcRoleOwner.Name);
   Console.WriteLine("Inhaber der PdcRole: " + d.PdcRoleOwner.Name);

   // Informationen über Forest der aktuellen Domäne
   Forest f = d.Forest;
			Console.WriteLine("Name des Forest: " + f.Name);
			Console.WriteLine("Modus des Forest: " + f.ForestMode);
		}

  // Alle DC ausgeben
  [AutoRun]
  public void DomaenenController()
  {
   // Aktuelle Domain ermitteln
   DirectoryContext dc = new DirectoryContext(DirectoryContextType.Domain, "LDAP://dc=it-objects,dc=net");

   Domain d = System.DirectoryServices.ActiveDirectory.Domain.GetDomain(dc);

   DomainControllerCollection DCs = d.DomainControllers;
   // Schleife über alle DC
   foreach (DomainController DC in DCs)
   {
    Console.WriteLine("Name: " + DC.Name);
    Console.WriteLine("IP: " + DC.IPAddress.ToString());
    Console.WriteLine("Zeit: " + DC.CurrentTime.ToString());
    Console.WriteLine("Rollen:");
    // Schleife über alle Rollen des DC
    foreach (ActiveDirectoryRole R in DC.Roles)
    {
     Console.WriteLine("- " + R.ToString());
    }
   }
  }
	}
}
