﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

namespace N2C.FCL
{
 [de.ITVisions.DemoViewer.Demo]
 public class ConsoleDemo
 {
  public ConsoleDemo()
  {
   // Fensterüberschrift
   Console.Title = "Konsolendemo";
   // Fensterposition
   Console.WindowLeft = 0;
   Console.WindowTop = 0;
   Console.SetWindowPosition(0, 0);
   // Farbe für Schrift
   Console.BackgroundColor = ConsoleColor.White;
   Console.ForegroundColor = ConsoleColor.Red;
   // Fenstergröße
   Console.SetWindowSize(60, 30);
   Console.CursorVisible = false;
   // Ausgabe an bestimmte Stelle platzieren
   for (int a = 0; a < 20; a++)
   {
    Console.CursorTop = a;
    Console.CursorLeft = a;
    Console.Write("x");
   }
   Console.CursorTop = 22;
   Console.CursorLeft = 0;
   // Ausgabe von Informationen über das Fenster
   Console.BackgroundColor = ConsoleColor.Black;
   Console.ForegroundColor = ConsoleColor.Yellow;
   Console.WriteLine(Console.LargestWindowHeight);
   Console.WriteLine(Console.LargestWindowWidth);
   // Ausgabe über den Bildschirm bewegen
   for (int a = 0; a < 20; a++)
   {
    Console.MoveBufferArea(a, 22, 3, 3, a+1, 22);
    System.Threading.Thread.Sleep(500);
   }
   Console.Beep();
   // Warten auf Eingabe
   Console.ReadKey();
  }
 }
}
