﻿#region Using directives

using System;
using System.Collections.Generic;

#endregion
using System.Text;
using de.ITVisions.DemoViewer;
using System.Text.RegularExpressions;

namespace N2C.FCL
{

 [Demo]
 public class Text
 {

  
  public void Encoding_Test()
  {

   byte[] NameAlsBytes;
   string Name = "Dr. Holger Schwichtenberg";
   Demo.Print("--- Umwandlung zwischen Bytes und Zeichenkette");
   ASCIIEncoding Encoder = new ASCIIEncoding();
   NameAlsBytes = Encoder.GetBytes(Name);
   Demo.Print("Dieser Name als Bytefolge:");
   foreach (byte b in NameAlsBytes)
   {
    Console.Write(b + ";");
   }
   Demo.Print("");

   Name = Encoder.GetString(NameAlsBytes);
   Demo.Print("Ursprünglicher Name:" + Name);
  }

  
  public void Mustervergleich()
  {
   const string RA_GUID = @"\{[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9|a-f|A-F]{12}\}";
   const string RA_IPAdresse = @"\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b";
   const string RA_EMail = @"^(?<user>[^@]+)@(?<host>.+)$";
   const string EINGABE1 = @"{00000615-0000-0010-8000-00AA006D2EA4}";
   const string EINGABE2 = @"192.168.123.355"; // Fehler!
   const string EINGABE3 = @"hs@IT-Visions.de";

   Demo.Print("GUID korrekt? " + Regex.IsMatch(EINGABE1, RA_GUID));
   Demo.Print("IP-Adresse korrekt? " + Regex.IsMatch(EINGABE2, RA_IPAdresse));
   Demo.Print("E-Mail-Adresse korrekt? " + Regex.IsMatch(EINGABE3, RA_EMail));
  }

  
  public void Musterersatz()
  {
   const String EINGABE = @"08/01/1972";
   const string MUSTER = @"\b(?<month>\d{1,2})/(?<day>\d{1,2})/(?<year>\d{2,4})\b";
   const string ERSATZ = @"${day}-${month}-${year}";
   Demo.Print("Alt: " + EINGABE);
   Demo.Print("Neu: " + Regex.Replace(EINGABE, MUSTER, ERSATZ));
  }
 }
}
