' Beispiele 
' Autor: Holger Schwichtenberg
' http://www.komponenten.info

Imports System.IO
Imports System.Xml
Imports System.Text
Imports System.Console

Module ReaderWriter

 Const ANZ_ELEMENTE As Long = 500000
 Const DATEI As String = "..\daten\counter.xml"

  ' === Dokument lesen mit Reader
  Sub xmlreader1()

    WriteLine("test")
    '---    Reader
    Dim r As XmlTextReader
    r = New XmlTextReader(DATEI)

    ' --- Schleife zum Lesen
    Do While r.Read
      '    'out(r.Name & ":" & r.Value)

      '    'MsgBox(d.InnerXml)
      If r.Name = "url" Then
        '        r.ReadInnerXml()
        'r.ReadStartElement("url")
        Dim d As New XmlDocument()

        d.LoadXml(r.ReadOuterXml())
        MsgBox(d.InnerXml)

      End If
    Loop

    'Dim p As New XPath.XPathDocument(r)
    'Dim n As XPath.XPathNavigator = p.CreateNavigator
    'XPATH_Rekursiv_ausgeben(n, 0)
    'MsgBox("OK")


    'End If
    'If r.HasAttributes Then
    '    Dim i As Integer
    '    For i = 0 To r.AttributeCount - 1
    '        r.MoveToAttribute(i)
    '        out(r.Name & "=" & r.Value)
    '    Next i
    'End If
    'Loop
  End Sub

  ' === Dokument lesen mit Reader (Geschwindigkeitstest)
  Sub xmlreader_speed()
    Const DATEI = "..\daten\preisliste.xml"
    '---    Reader
    ts("XMLReader:laden")
    Dim r As XmlTextReader
    r = New XmlTextReader(DATEI)
    te()
    ts("XMLReader:durchlaufen")
    ' --- Schleife zum Lesen
    Do While r.Read
      If r.HasAttributes Then
        Dim i As Integer
        For i = 0 To r.AttributeCount - 1
          r.MoveToAttribute(i)
        Next i
      End If
    Loop
    r.Close()
    te()
 End Sub

 ' === Dokument lesen mit Reader (Geschwindigkeitstest)
 Sub xmlreader_speed_net2()
  Const DATEI = "..\daten\preisliste.xml"
  '---    Reader
  ts("XMLReader2:laden")
  Dim rs As XmlReaderSettings = New XmlReaderSettings
  rs.ConformanceLevel = ConformanceLevel.Fragment
  rs.IgnoreWhitespace = True
  rs.IgnoreComments = True
  Dim r As XmlReader = XmlReader.Create(DATEI, rs)
  te()
  ts("XMLReader2:durchlaufen")
  ' --- Schleife zum Lesen
  Do While r.Read
   If r.HasAttributes Then
    Dim i As Integer
    For i = 0 To r.AttributeCount - 1
     r.MoveToAttribute(i)
    Next i
   End If
  Loop
  r.Close()
  te()
 End Sub


  ' === Dokument lesen mit Reader
  Sub xmlreader3()
    '---    Reader
    Dim r As XmlTextReader
    Dim d As New XmlDocument()
    Dim n As XmlNode
    r = New XmlTextReader(DATEI)
    'r.ReadStartElement("url")
    ' --- Schleife zum Lesen
    Do While r.Read
      out(r.Name & "=" & Replace(r.Value, Chr(13), ""))
      'n = d.ReadNode(r)
      'out(n.InnerXml)
    Loop
    r.Close()
  End Sub


  ' === Preisliste erzeugen
  Sub xmlwriter()
    Dim a As Long
  Const DATEI As String = "..\daten\preisliste.xml"
    Dim tw As XmlTextWriter
    Dim s As FileStream

    out("Vorbereitung")

    s = File.Create(DATEI)
    tw = New XmlTextWriter(s, Encoding.UTF8)

  out("Erzeugen von " & ANZ_ELEMENTE & " Produkten...")

    tw.WriteStartDocument()
    tw.WriteComment("Erstellt von HS am 7.12.2001")
    tw.WriteStartElement("Preisliste")

  For a = 1 To ANZ_ELEMENTE
   tw.WriteStartElement("Produkt")
   tw.WriteAttributeString("ID", a)
   tw.WriteElementString("Produktname", "Produkt #" & a)
   tw.WriteStartElement("Preise")
   tw.WriteElementString("EK-Preis", 1000)
   tw.WriteElementString("VK-Preis", 1200)
   tw.WriteEndElement()
   tw.WriteEndElement()
  Next

    tw.WriteEndElement()
    tw.WriteEndDocument()

    out("Schliesen...")
    tw.Close()
    s.Close()
  End Sub

  ' === Preisliste erzeugen
  Sub xmlwriter_speed()
    Dim a As Long
  Const DATEI As String = "..\daten\preisliste.xml"
    Dim tw As XmlTextWriter
    Dim s As FileStream

    ts("XMLWriter:Vorbereitung")

    s = File.Create(DATEI)
    tw = New XmlTextWriter(s, Encoding.UTF8)
    tw.WriteStartDocument()
    tw.WriteComment("Erstellt von HS am 7.12.2001")

    te()
    ts("XMLWriter:Erzeugen...")

    tw.WriteStartElement("Preisliste")

  For a = 1 To ANZ_ELEMENTE
   tw.WriteStartElement("Produkt")
   tw.WriteAttributeString("ID", a)
   tw.WriteElementString("Produktname", "Produkt #" & a)
   tw.WriteStartElement("Preise")
   tw.WriteElementString("EK-Preis", 1000)
   tw.WriteElementString("VK-Preis", 1200)
   tw.WriteEndElement()
   tw.WriteEndElement()
  Next

    tw.WriteEndElement()
    tw.WriteEndDocument()
    te()
    ts("XMLWriter:Schliessen")
    tw.Close()
    s.Close()
    te()
  End Sub






End Module
