' Beispiele 
' Autor: Holger Schwichtenberg
' http://www.komponenten.info

Imports System.Xml
Imports System.IO
Imports System.Text

Module XML
    Const DATEI = "..\daten\counter.xml"

    ' === XML Dokument lesen
    Sub xml_DOM1()
        Dim d As XmlDocument
        Dim i As XmlImplementation
    Dim urlElement As XmlElement
        Dim l As XmlNodeList

        ' --- Dokument laden
    d = New XmlDocument
        d.Load(DATEI)
    'i = d.Implementation
    'out(i.HasFeature("XML", "1.0"))
    'out(d.InnerXml)

    ' --- Elemente auflisten

        l = d.SelectNodes("*//url")

        ' --- Alle Counter auflisten
    For Each urlElement In l
      out(urlElement.Attributes("name").Value & " = " & _
      urlElement.SelectSingleNode("count").FirstChild.Value)

    Next

    End Sub

    ' === XML aus String laden
    Sub xml_DOM4()
        Dim d As New XmlDocument()
        d.LoadXml("<Website><Url>http://www.IT-Visions.de</Url></Website>")
        out(d.InnerXml)
    End Sub

    ' === ndern des Inhalts
    Sub xml_DOM2()
        Dim d As New XmlDocument()
        Dim e As XmlElement
        Dim l As XmlNodeList

        Const WEBSEITE = "default.asp"

        ' --- Dokument laden
        d.Load(DATEI)

        ' --- Einzelnes Element auswhlen
        e = d.SelectSingleNode("*//url[@name='/" & WEBSEITE & "']/count")


        out("Alter Wert:" & e.FirstChild.Value)
        ' --- Counter erhhen!
        e.FirstChild.Value += 1
        out("Neuer Wert:" & e.FirstChild.Value)
        ' --- Dokument speichern
        d.Save(DATEI)
    End Sub

    ' === Beispiel zur Strukturvernderung: neuer Counter
    Sub xml_DOM3()
        Dim doc As New XmlDocument()
        Dim newe As XmlElement
        Dim e As XmlElement
        Dim a As XmlAttribute

        doc.Load(DATEI)

        ' --- Startelement suchen
        e = doc.SelectSingleNode("counter")

        ' --- Neues Element
    newe = doc.CreateNode(XmlNodeType.Element, "url", "")
        e.AppendChild(newe)

        ' --- Neues Attribut
        a = doc.CreateAttribute("name")
        a.Value = "/menu.asp"
        newe.SetAttributeNode(a)

        ' --- Elternelement wechseln
        e = newe

        ' --- Neues Element
        newe = doc.CreateNode(XmlNodeType.Element, "aktiv", "")
        e.AppendChild(newe)

        ' --- Neues Element
        newe = doc.CreateNode(XmlNodeType.Element, "count", "")
        newe.InnerText = "1"
        e.AppendChild(newe)

        ' --- Neues Element
        newe = doc.CreateNode(XmlNodeType.Element, "lastaccess", "")
        newe.InnerText = DateTime.Now
        e.AppendChild(newe)

        ' --- Dokument speichern
        out(doc.InnerXml)
        doc.Save(DATEI)


    End Sub

    ' ### Rekursive Ausgabe eines XML-Dokuments
    Sub xml_Reklist(ByVal xVater As XmlNode, ByVal ebene As Integer)
        Dim xSohn As XmlNode
        Dim s
        s = Space(ebene) & xVater.Name & " (" & xVater.NodeType & ")"
        If xVater.Value <> "" Then s = s & " = " & xVater.Value
        out(s)
        ' --- Enthlt der Knoten Attribute?
        If Not xVater.Attributes Is Nothing Then
            ' --- Iterartion ber alle Attribute
            For Each xSohn In xVater.Attributes
                xml_Reklist(xSohn, ebene + 1)
            Next
        End If
        ' --- Enthlt der Knoten Unterknoten?
        If Not xVater.ChildNodes Is Nothing Then
            ' --- Iterartion ber alle Shne
            For Each xSohn In xVater.ChildNodes
                xml_Reklist(xSohn, ebene + 1)
            Next
        End If
    End Sub

    ' ### Rekursive Ausgabe eines XML-Dokuments
    Sub xml_Rek(ByVal xVater As XmlNode, ByVal ebene As Integer)
        Dim xSohn As XmlNode
        Dim s

        ' --- Enthlt der Knoten Attribute?
        If Not xVater.Attributes Is Nothing Then
            ' --- Iterartion ber alle Attribute
            For Each xSohn In xVater.Attributes
                xml_Rek(xSohn, ebene + 1)
            Next
        End If
        ' --- Enthlt der Knoten Unterknoten?
        If Not xVater.ChildNodes Is Nothing Then
            ' --- Iterartion ber alle Shne
            For Each xSohn In xVater.ChildNodes
                xml_Rek(xSohn, ebene + 1)
            Next
        End If
    End Sub

    ' === Geschwindigkeitstest
    Sub xmldom_speed()
    Const DATEI = "..\daten\preisliste.xml"
        ts("XMLDOM:laden")
        Dim d As XmlDocument
        d = New XmlDocument()
        d.Load(DATEI)
        te()

        ts("XMLDOM:Durchlauf")

        xml_Rek(d, 0)
        te()
    End Sub

End Module
