' Beispiele 
' Autor: Holger Schwichtenberg
' http://www.komponenten.info

Imports System.Xml.Xsl
Imports System.Xml
Imports System.Xml.XPath
Imports System.IO

Module XLST

    ' === XSLT Transformation von Datei in Datei
    Sub XLST_1()

        Const XMLDATEI = "..\daten\hs2.xml"
        Const XSLTDATEI = "..\daten\referent.xsl"
        Const AUSGABEDATEI = "..\daten\hs.htm"

        ' --- Klassen instanziieren
        Dim xslt As New XslTransform()
        ' --- Stylesheet laden
        xslt.Load(XSLTDATEI)
        ' --- Dokument laden, transformieren und speichern
        xslt.Transform(XMLDATEI, AUSGABEDATEI)

        out("Transformation in Datei OK: " & AUSGABEDATEI)
    End Sub

    ' === XLST Transformation von Datei in Stream
    Sub XLST_2()
        Const XMLDATEI = "..\daten\hs2.xml"
        Const XSLTDATEI = "..\daten\referent.xsl"
        Const AUSGABEDATEI = "..\Daten\hs.htm"

        ' --- Klassen instanziieren
        Dim xslt As New XslTransform()
        ' --- Stylesheet laden
        xslt.Load(XSLTDATEI)
        ' --- Dokument laden
        Dim xpd As New XPathDocument(XMLDATEI)
        ' --- Transformieren und Ausgabe in Stream (Datei)
        Dim stream As FileStream
        stream = New FileStream(AUSGABEDATEI, FileMode.Create)
        xslt.Transform(xpd, Nothing, stream)
        ' --- Transformieren und Ausgabe in Textwriter (Konsole)
        Dim tw As TextWriter
        tw = Console.Out
        xslt.Transform(xpd, Nothing, tw)

        out("Transformation OK")
    End Sub


End Module
