/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.osgi.framework.internal.core.PermissionsHash;
import org.eclipse.osgi.framework.internal.core.UnresolvedPermission;
import org.eclipse.osgi.framework.internal.core.UnresolvedPermissionCollection;
import org.osgi.framework.Bundle;

final class BundlePermissions
extends BundlePermissionCollection {
    private static final long serialVersionUID = 3257844389794428984L;
    private Hashtable collections = new Hashtable(8);
    private PermissionCollection allPermission;
    private PackageAdminImpl packageAdmin;
    static /* synthetic */ Class class$0;

    BundlePermissions(PackageAdminImpl packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        PermissionCollection collection;
        if (this.isReadOnly()) {
            throw new SecurityException();
        }
        Hashtable hashtable = this.collections;
        synchronized (hashtable) {
            collection = this.findCollection(permission);
            if (collection == null) {
                collection = this.newPermissionCollection(permission);
            }
        }
        if (permission instanceof AllPermission) {
            this.allPermission = collection;
        }
        collection.add(permission);
    }

    public Enumeration elements() {
        return new Enumeration(){
            Enumeration enumMap;
            PermissionCollection c;
            Enumeration enumC;
            Permission next;
            {
                this.enumMap = BundlePermissions.this.collections.elements();
                this.next = this.findNextPermission();
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            public Object nextElement() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Permission answer = this.next;
                this.next = this.findNextPermission();
                return answer;
            }

            private Permission findNextPermission() {
                while (this.c == null && this.enumMap.hasMoreElements()) {
                    this.c = (PermissionCollection)this.enumMap.nextElement();
                    this.enumC = this.c.elements();
                    if (this.enumC.hasMoreElements()) continue;
                    this.c = null;
                }
                if (this.c == null) {
                    return null;
                }
                Permission answer = (Permission)this.enumC.nextElement();
                if (!this.enumC.hasMoreElements()) {
                    this.c = null;
                }
                return answer;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection findCollection(Permission permission) {
        Class<?> clazz = permission.getClass();
        PermissionCollection collection = (PermissionCollection)this.collections.get(clazz);
        if (collection == null) {
            Hashtable hashtable = this.collections;
            synchronized (hashtable) {
                collection = (PermissionCollection)this.collections.get(clazz);
                if (collection == null) {
                    collection = this.resolvePermissions(permission);
                }
            }
        }
        return collection;
    }

    private PermissionCollection resolvePermissions(Permission permission) {
        String name;
        Vector permissions;
        UnresolvedPermissionCollection unresolvedCollection;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.UnresolvedPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((unresolvedCollection = (UnresolvedPermissionCollection)this.collections.get(clazz)) != null && (permissions = unresolvedCollection.getPermissions(name = permission.getClass().getName())) != null) {
            PermissionCollection collection = null;
            Class<?> clazz2 = permission.getClass();
            if (clazz2 == null) {
                return null;
            }
            Enumeration permsEnum = permissions.elements();
            while (permsEnum.hasMoreElements()) {
                Permission resolved = ((UnresolvedPermission)permsEnum.nextElement()).resolve(clazz2);
                if (resolved == null) continue;
                if (collection == null) {
                    collection = this.newPermissionCollection(resolved);
                }
                collection.add(resolved);
            }
            return collection;
        }
        return null;
    }

    private PermissionCollection newPermissionCollection(Permission permission) {
        PermissionCollection collection = permission.newPermissionCollection();
        if (collection == null) {
            collection = new PermissionsHash();
        }
        this.collections.put(permission.getClass(), collection);
        return collection;
    }

    public boolean implies(Permission perm) {
        if (this.allPermission != null && this.allPermission.implies(perm)) {
            return true;
        }
        PermissionCollection collection = this.findCollection(perm);
        if (collection == null) {
            return false;
        }
        return collection.implies(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unresolvePermissions(AbstractBundle[] refreshedBundles) {
        Hashtable hashtable = this.collections;
        synchronized (hashtable) {
            int size = this.collections.size();
            Class[] clazzes = new Class[size];
            Enumeration keysEnum = this.collections.keys();
            int i = 0;
            while (i < size) {
                clazzes[i] = (Class)keysEnum.nextElement();
                ++i;
            }
            i = 0;
            while (i < size) {
                Class clazz = clazzes[i];
                Bundle bundle = this.packageAdmin.getBundle(clazz);
                if (bundle != null) {
                    int j = 0;
                    while (j < refreshedBundles.length) {
                        if (refreshedBundles[j] == bundle) {
                            if (Debug.DEBUG_SECURITY) {
                                Debug.println("  Unresolving permission class " + clazz.getName());
                            }
                            this.collections.remove(clazz);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }
}

