/*
 * Created on 04.03.2005
 *
 */
package ix.swt;

import java.io.File;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
/**
 * 
 * @author Tobias Himstedt for iX
 *
 */
public class TreeTest {

	private org.eclipse.swt.widgets.Shell sShell = null;
	public void createTree() {
	    
	    
		TreeViewer tv = new TreeViewer(sShell);
		FileTreeContentProvider provider = new FileTreeContentProvider();
		tv.setContentProvider(provider);
		tv.setInput( File.listRoots()[0] );
		
	
	}
	
	
      public static void main(String[] args) {
   
		/* Before this is run, be sure to set up the following in the launch configuration 
		 * (Arguments->VM Arguments) for the correct SWT library path. 
		 * The following is a windows example:
		 * -Djava.library.path="installation_directory\plugins\org.eclipse.swt.win32_3.0.0\os\win32\x86"
		 */
		org.eclipse.swt.widgets.Display display = org.eclipse.swt.widgets.Display.getDefault();		
		TreeTest thisClass = new TreeTest();
		thisClass.createSShell() ;
		thisClass.sShell.open();
		while (!thisClass.sShell.isDisposed()) {
			if (!display.readAndDispatch()) display.sleep ();
		}
		display.dispose();		
 }

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		sShell = new org.eclipse.swt.widgets.Shell();		   
		sShell.setLayout(new FillLayout());
		sShell.setText("sShell");
		sShell.setSize(new org.eclipse.swt.graphics.Point(300,200));
		createTree();
	}
}

class FileTreeContentProvider implements ITreeContentProvider {

    public Object[] getChildren(Object parentElement) {
        File file = (File) parentElement;
        if (file.isDirectory()) {
            return file.listFiles();
        }
        return null;
    }

    public Object getParent(Object element) {
        return ((File)element).getParent();
    }

    public boolean hasChildren(Object element) {
        File file = (File) element;
        if (file.isDirectory())
            return file.list().length > 0;
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    public void dispose() {}

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}
    
}

