﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.WWWings;
using de.ITVisions.DALUtil;
using System.EnterpriseServices;
using System.Runtime.CompilerServices;
using System.Reflection;

namespace de.WWWings.DAL
{
 [Description("Flugmanager für WorldWideWings")]
 [System.EnterpriseServices.Synchronization(SynchronizationOption.Required)]
 [Transaction(TransactionOption.Required)]
 [ObjectPoolingAttribute(true, 10, 20)]
 [EventTrackingEnabled(true)]
 [System.Runtime.InteropServices.Guid("9C74BA6A-9D1C-4fe7-808E-04E6665D0251")]
 public class Flug_DataManager : ServicedComponent, de.WWWings.DAL.IFlug_DataManager
 {

     private void Test(string a, int b, long c, DateTime e)
     {

     }

  public Flug_DataManager()
  {
   DBUtil.SetDatabase(DBUtil.Providers.MSSQL, DBConfig.CONN_MSSQL);
   //DBUtil.SetDatabase(DBUtil.Providers.ACCESS, CONN_ACCESS);
  }

  // === Daten lesen mit einem DataReader
  public SqlDataReader AlleFluege_DR()
  {
   const string SQL = "Select * from FL_Fluege";
   return SQLUtil.GetReader(SQL);
  }

  // === Daten lesen mit einem DataReader
  public SqlDataReader AlleFluegeFuerAbflughafen_DR(string Abflughafen)
  {
   string SQL = "Select * from FL_Fluege where Fl_Abflughafen = '" + Abflughafen + "'";
   return SQLUtil.GetReader(SQL);
  }

  // === Daten lesen mit einem DataReader
  public SqlDataReader GetFlug_DR(long FlugNr)
  {
   string SQL = "Select * from FL_Fluege where fl_flugnr = " + FlugNr + "";
   SqlDataReader dr = SQLUtil.GetReader(SQL);
   dr.Read();
   return dr;
  }

  public static string[] AlleAbflughaefen()
  {
   const string SQL = "Select FL_Abflugort from FL_Fluege group by FL_Abflugort";
   return SQLUtil.GetColumn(SQL);
  }

  public static DataSet AlleFluege_DS()
  {
   const string SQL = "Select * from FL_Fluege";
   return SQLUtil.GetDataSet(SQL);
  }
  
  public static DataSet AlleFluege_DS(long von, long bis)
  {
   string SQL = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege) Select * from ordered where RowNumber between " + von + " and " + bis;
   return SQLUtil.GetDataSet(SQL);
  }

  public static DataSet AlleFluege_DS(string sort, long von, long bis)
  {
   if (sort == "") return AlleFluege_DS(von, bis);
   string SQL = "With ordered as (Select Row_Number() Over (order by FL_FlugNr) as RowNumber, * from FL_Fluege) Select * from ordered where RowNumber between " + von + " and " + bis + " order by " + sort;
   return SQLUtil.GetDataSet(SQL);
  }


  public static DataSet AlleFluege_DS(string Abflugort)
  {
   string SQL = "Select * from FL_Fluege where Fl_Abflugort = '" + Abflugort + "'";
   return SQLUtil.GetDataSet(SQL);
  }


  public static DataSet Abflugort()
  {
   const string SQL = "Select Fl_Abflugort from FL_Fluege group by Fl_Abflugort";
   return SQLUtil.GetDataSet(SQL);
  }


  public static void Update(DataSet ds)
  {
   SQLUtil.UpdateDS(ds, "Select * from FL_fluege");
  }


  public static void Update(string FL_Abflugort, string FL_ZielOrt, long FL_Plaetze, long original_Fl_FlugNr)
  {
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" + FL_Abflugort + "', FL_ZielOrt = '" + FL_ZielOrt + "', FL_Plaetze = " + FL_Plaetze + " WHERE Fl_FlugNr = " + original_Fl_FlugNr);
   return;
  }

  public static void Update(string FL_Abflugort, string FL_ZielOrt, long FL_Plaetze, bool FL_NichtRaucherFlug, DateTime FL_EingerichtetAm, int original_Fl_FlugNr)
  {
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" + FL_Abflugort + "', FL_ZielOrt = '" + FL_ZielOrt + "', FL_Plaetze = " + FL_Plaetze + " WHERE Fl_FlugNr = " + original_Fl_FlugNr);

  }

  public static void Update(string FL_Abflugort, string FL_ZielOrt, DateTime FL_Datum, bool FL_NichtRaucherFlug, long FL_Plaetze, int FL_FreiePlaetze, long FL_PI_MI_MitarbeiterNr, long FL_AnzahlStarts, DateTime FL_EingerichtetAm, int Fl_FlugNr)
  {
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Abflugort = '" + FL_Abflugort + "', FL_ZielOrt = '" + FL_ZielOrt + "', FL_Plaetze = " + FL_Plaetze + " WHERE Fl_FlugNr = " + Fl_FlugNr);

  }

  public static void Insert(string FL_Abflugort, string FL_ZielOrt, bool FL_NichtRaucherFlug, long FL_Plaetze, DateTime FL_EingerichtetAm, int FL_FlugNr)
  {
   SQLUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, Fl_Plaetze, Fl_NichtraucherFlug) Values (" + FL_FlugNr + ",'" + FL_Abflugort + "', '" + FL_ZielOrt + "', " + FL_Plaetze + ", '" + FL_NichtRaucherFlug + "')");

  }

  public static void Insert(string FL_Abflugort, string FL_ZielOrt, bool FL_NichtRaucherFlug, long FL_Plaetze, long FL_FreiePlaetze, DateTime FL_Datum, DateTime FL_EingerichtetAm, int FL_FlugNr)
  {
   SQLUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, FL_Datum, Fl_Plaetze, Fl_FreiePlaetze,Fl_NichtraucherFlug) Values (" + FL_FlugNr + ",'" + FL_Abflugort + "', '" + FL_ZielOrt + "', '" + FL_Datum.ToString(new System.Globalization.CultureInfo("en-us")) + "'," + FL_Plaetze + ", " + FL_FreiePlaetze + ",'" + FL_NichtRaucherFlug + "')"); 

  }

  public static void Insert(string FL_Abflugort, string FL_Zielort, DateTime FL_Datum, bool FL_NichtRaucherFlug, long FL_Plaetze, long FL_FreiePlaetze, long FL_PI_MI_MitarbeiterNr,long FL_AnzahlStarts,DateTime FL_EingerichtetAm,   int Fl_FlugNr)
  {
   SQLUtil.Execute("Insert into Fl_Fluege (Fl_Flugnr, FL_Abflugort, Fl_Zielort, FL_Datum, Fl_Plaetze, Fl_FreiePlaetze,Fl_NichtraucherFlug) Values (" + Fl_FlugNr + ",'" + FL_Abflugort + "', '" + FL_Zielort + "', '" + FL_Datum.ToString(new System.Globalization.CultureInfo("en-us")) + "'," + FL_Plaetze + ", " + FL_FreiePlaetze + ",'" + FL_NichtRaucherFlug + "')");
  }

  [AutoComplete]
  public void reset()
  {
   SQLUtil.Execute("UPDATE Fl_Fluege SET FL_Plaetze = 300");
  }

  [AutoComplete]
  public void OneChange()
  {
   long anz = SQLUtil.Execute("UPDATE Fl_Fluege SET FL_FreiePlaetze = " + Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(200)));
   Console.WriteLine("Rows Affected: " + anz);
  }


  [AutoComplete]
  public void Init()
  {
   string[] Flughaefen = { "Berlin", "Frankfurt", "München", "Hamburg", "Köln/Bonn", "Rom", "London", "Paris", "Mailand", "Prag", "Moskau", "New York", "Seattle" };
   DBUtil.ClearTable("Fl_Fluege");
   Console.WriteLine("Tabelle FL_Fluege wird initialisiert...");
   int FlugNr = 500;
   foreach (string von in Flughaefen)
   {
    foreach (string nach in Flughaefen)
    {
     //try
     //{
     if (von != nach)
     {
      DateTime FlugDatum = DateTime.Now.AddMinutes(Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(5000)));

      Insert(von, nach, true, 200, Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(200)), FlugDatum , DateTime.Now, FlugNr);
      System.Console.WriteLine(von + "->" + nach);
      System.EnterpriseServices.ContextUtil.SetComplete();

     }
     //}
     //catch
     //{ }
     //
     FlugNr++;
    }
   }
  }


  public static void LoescheFlug(int Original_Fl_FlugNr)
  {
   SQLUtil.Execute("Delete from Fl_Fluege where Fl_FlugNr = " + Original_Fl_FlugNr + "");
  }
 }

  public class Flug_DataManager2
  {


   public delegate void FluegeWurdenAktualisiertHandler();
   public event FluegeWurdenAktualisiertHandler FluegeWurdenAktualisiert;
   System.Data.SqlClient.SqlDependency dep;
   public void AktualisierungenMelden(string Zielort)
   {
    dep = SQLUtil.DeclareQueryNotfication("Select FL_FlugNr,Fl_Abflugort, FL_Zielort, Fl_Plaetze, Fl_FreiePlaetze from dbo.FL_Fluege where FL_zielort = '" + Zielort + "'");
 
    dep.OnChange += new OnChangeEventHandler(dep_OnChange);


   }

   void dep_OnChange(object sender, SqlNotificationEventArgs e)
   {
    if (e.Type == SqlNotificationType.Subscribe)
    {
     throw new Exception("Fehler in Query Notification: " + e.Info.ToString());
    }
    else
    {
     if (FluegeWurdenAktualisiert != null) FluegeWurdenAktualisiert();
    }
   }


  

 }
}
