﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using System.EnterpriseServices;
namespace de.WWWings
{
 /// <summary>
 /// Diese Klasse repräsentiert einen Flug!
 /// </summary>
 [Description("Flug-Klasse")]
 [Transaction(TransactionOption.Required)]
 [ObjectPoolingAttribute(true, 10, 20)]
 [EventTrackingEnabled(true)]
 [System.EnterpriseServices.Synchronization(SynchronizationOption.Required)]
 [System.Diagnostics.DebuggerDisplay("Flug Nr={FlugNr}")] 
 public partial class Flug 
 {
  
  // ========== Klassenmitglieder
  [System.CLSCompliant(true)]
  public static de.WWWings.Fluege Fluege = new de.WWWings.Fluege();
  // ========== Attribute
  private long flugNr;
  public long FlugNr
  {
   get { return flugNr; }
   set { flugNr = value; }
  }

  private string abflugOrt;
  public string AbflugOrt
  {
   get { return abflugOrt; }
   set { abflugOrt = value; }
  }

  private string zielOrt;
  public string ZielOrt
  {
   get { return zielOrt; }
   set { zielOrt = value; }
  }

  private long plaetze;
  public long Plaetze
  {
   get { return plaetze; }
   set { plaetze = value; }
  }

  private long freiePlaetze;
  public long FreiePlaetze
  {
   get { return freiePlaetze; }
   set { freiePlaetze = value; }
  }

  public DateTime Datum = System.DateTime.Now;

  [System.Diagnostics.DebuggerDisplay("Pilot={Pilot.GanzerName}")]
  [System.Diagnostics.DebuggerBrowsable(System.Diagnostics.DebuggerBrowsableState.Collapsed)]
  public de.WWWings.MitarbeiterSystem.Pilot Pilot;
 }
}

