﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion
using de.WWWings.PassagierSystem;
using de.WWWings;

namespace de.WWWings.PassagierSystem
{
 
	[System.Serializable()]
	public class Passagier : de.WWWings.Person
	{

		public delegate void CheckInStartHandler(Passagier p);
		public delegate void CheckInEndeHandler(Passagier p);

		// ========== Klassenmitglieder
		[System.CLSCompliant(false)]
		public static de.WWWings.PassagierSystem.Passagiere Passagiere = new Passagiere();
		// ========== Attribute (Fields)
		[System.CLSCompliant(false)]
		public de.WWWings.Fluege Fluege = new de.WWWings.Fluege();
		public readonly long PID;
		private de.WWWings.Flug _AktuellerFlug;
		//  ========== Errechnete Attribute (Properties)
		public Flug AktuellerFlug
		{
			get
			{
  
				return this._AktuellerFlug;
			}
  }
		// =========== Ereignisse
		public static event CheckInStartHandler CheckInStart;
		public static event CheckInEndeHandler CheckInEnde;
		// ========== Konstruktoren
  public Passagier()
  {
  }

		public Passagier(string Name, string Vorname)
			: base(Name, Vorname)
		{
			this.PID = Passagier.Passagiere.Add(this);
		}

		public Passagier(long PID)
		{
			this.PID = PID;
		}
		// ========== Methoden

		

  /// <summary>Einchecken eines Passagiers für einen Flug</summary>
  /// <param name="Flugnummer">Die Methode erwartet eine Flugnummer</param>
  /// <returns>Die Methode liefert als Rückgabewert das Flugobjekt, wenn das Einchecken erfolgreich war.</returns>
		public Flug CheckIn(long Flugnummer)
		{
			if (CheckInStart != null)
			{
				CheckInStart(this);
			}

			if (!(this.Fluege.ContainsKey(Flugnummer)))
			{
				throw new de.WWWings.PassagierSystem.PassagierNichtAufFlugGebucht(this.PID + "/" + Flugnummer);
			}
			else
			{
				if (CheckInEnde != null)
				{
					CheckInEnde(this);
				}
				return this.Fluege[Flugnummer];
			}
		}
		public override void Info()
		{
			Console.WriteLine("Passagier: " + this.GanzerName);
		}


  ///----- Ausimplementiert
  ///

		private DAL.Passagier_DataManager DAL = new de.WWWings.DAL.Passagier_DataManager();

  /// <summary>
  /// Einzelbuchung
  /// </summary>
  /// <param name="Flugnummer"></param>
  /// <returns></returns>
  public long Buchen(long Flugnummer)
  {
   if (!(Flug.Fluege.ContainsKey(Flugnummer)))
   {
    throw new de.WWWings.PassagierSystem.FalscheFlugnummer(this.PID + "/" + Flugnummer);
   }
   else
   {
    this.Buchen(de.WWWings.Flug.Fluege[Flugnummer]);
    return DAL.Buchung(this.PID, Flugnummer);
   }
  }

  public Buchung Buchen(de.WWWings.Flug flug)
  {
   this.Fluege.Add(flug.FlugNr, flug);
   Buchung b = new Buchung();
   b.Flug = flug;
   b.Passagier = this;
   return b;
  }

  /// <summary>
  /// Mehrfachbuchung (als Transaktion)
  /// </summary>
  /// <param name="Flugnummern"></param>
  public void Buchen(long[] Flugnummern)
  {
   DAL.MehrfachBuchung(this.PID, Flugnummern);
   //d.Dispose();
  }

  public long AlleBuchungenLoeschen()
  {
			return BuchungLoeschen();
  }

		private long BuchungLoeschen()
		{
			long anz = DAL.AlleBuchungenLoeschen(this.PID);
			//d.Dispose();
			return anz;
		}

  public System.Data.Common.DbDataReader AlleBuchungen()
  {

   System.Data.Common.DbDataReader r = DAL.AlleBuchungen(this.PID);
   //d.Dispose();
   return r;

  }
	}
}
