
Namespace de.WWWings.PassagierSystem

 '@ <summary>Diese Klasse reprsentiert einen Passagier.</summary>
 <System.Serializable()> _
 Public Class Passagier
  Inherits de.WWWings.Person

  ' ========== Klassenmitglieder
  Public Shared Passagiere As New Passagiere
  ' ========== Attribute
  Public Fluege As New Fluege
  Public ReadOnly PID As Long
  Private _AktuellerFlug As Flug
  ' ========== Ereignisse
  Public Shared Event CheckInStart(ByVal pass As Passagier)
  Public Shared Event CheckInEnde(ByVal pass As Passagier)
  ' ========== Konstruktoren
  Public Sub New(ByVal Name As String, ByVal vorname As String)
   MyBase.New(Name, vorname)
   Me.PID = Passagier.Passagiere.Add(Me)
  End Sub
  ' ========== Errechnete Attribute (Properties)
  Public ReadOnly Property AktuellerFlug() As Flug
   Get
    Return Me._AktuellerFlug
   End Get
  End Property
  ' ========== Methoden
  Public Overloads Sub Buchen(ByVal Flug As Flug)
   Me.Fluege.Add(Flug.FlugNr, Flug)
  End Sub
  Public Overloads Sub Buchen(ByVal Flugnummer As String)
   If Not Flug.Fluege.ContainsKey(Flugnummer) Then
    Throw New FalscheFlugnummer(Me.PID & "/" & Flugnummer)
   Else
    Me.Buchen(Flug.Fluege.Item(Flugnummer))
   End If
  End Sub

  Public Overloads Sub BuchenMitRaucherAngabe(ByVal Flugnummer As String, Optional ByVal NichtRaucher As Boolean = True)
   If Not Flug.Fluege.ContainsKey(Flugnummer) Then
    Throw New FalscheFlugnummer(Me.PID & "/" & Flugnummer)
   Else

    If NichtRaucher And Not Flug.Fluege.Item(Flugnummer).NichtRaucherFlug Then
     Throw New ApplicationException("Flug ist kein Nichtraucherflug: " & Flugnummer)
    Else
     Me.Buchen(Flug.Fluege.Item(Flugnummer))
    End If

   End If
  End Sub


  '@ <summary>Einchecken eines Passagier fr einen Flug</summary>
  '@ <param name="Text">Die Methode erwartet eine Flugnummer</param>
  '@ <returns>Die Methode liefert als Rckgabewert das Flugobjekt, wenn das einchecken erfolgreich war</returns>
  Public Function CheckIn(ByVal Flugnummer As String) As Flug
   RaiseEvent CheckInStart(Me)
   If Not Me.Fluege.ContainsKey(Flugnummer) Then
    Throw New PassagierNichtAufFlugGebucht(Me.PID & "/" & Flugnummer)
   Else
    RaiseEvent CheckInEnde(Me)
    Return Me.Fluege.Item(Flugnummer)
   End If
  End Function

  ' ========== Methode berschrieben von Klasse Person
  Public Overrides Sub Info()
   Console.WriteLine("Passagier: " & Me.GanzerName)
  End Sub

  ' ========== Methode berschrieben von Klasse System.Object

  Public Overrides Function ToString() As String
   Return ("Passagier: " & Me.GanzerName)
  End Function

 End Class
End Namespace
