﻿#region	Using	directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================
using de.ITVisions.DemoViewer;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;

using System.Data.OleDb;

namespace NET2.ADONET
{
 /// <summary>
 /// Summary description for ProviderEnum.
 /// </summary>
 [Demo]
 public class BulkImport
 {
  // Massenkopie zwischen SQL Server-Datenbanken ohne Optionen

  [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Naming", "CA1707:IdentifiersShouldNotContainUnderscores", MessageId = "Member")]
  public void run_SQLtoSQL_Einfach()
  {

   Demo.PrintHeader("Bulk Copy - SQL Server->SQL Server - Einfach");
   string CS_Quelle = DemoConfig.CONNSTRING;
   string CS_Ziel = DemoConfig.CONNSTRING;
   const string SQL_Quelle = "select * from FL_Fluege";
   const string ZIELTABELLE = "FLB_Fluege_Backup";

   // Aufräumen!
   //DE.ITVisions.SADO.Execute("Provider=SQLOLEDB;"+CS_Ziel, "Delete from FL_Fluege_Backup");


   // Verbindung zur Quelle
   Demo.Print("Verbindung zur Quelle öffnen...");
   SqlConnection C_Quelle = new SqlConnection(CS_Quelle);
   C_Quelle.Open();
   // Verbindung zum Ziel
   Demo.Print("Verbindung im Ziel öffnen...");
   SqlConnection C_Ziel = new SqlConnection(CS_Ziel);
   C_Ziel.Open();

   // Daten holen
   Demo.Print("Daten aus Quelle einlesen...");
   SqlCommand CMD_Quelle = new SqlCommand(SQL_Quelle, C_Quelle);
   SqlDataReader Reader = CMD_Quelle.ExecuteReader();

   // Kopiervorgang
   Demo.Print("Daten in Zieltabelle schreiben...");
   SqlBulkCopy BulkCopy = new SqlBulkCopy(C_Ziel);
   BulkCopy.DestinationTableName = ZIELTABELLE;
   BulkCopy.WriteToServer(Reader);

   // Ende
   Reader.Close();
   C_Quelle.Close();
   C_Ziel.Close();
  }


  // Massenkopie von Access-Datenbank in SQL Server-Datenbank
  public void run_AccessToSQL()
  {

   Demo.PrintHeader("Bulk Copy - Access->SQL Server - Einfach");
   const string CS_Quelle = @"Provider='Microsoft.Jet.OLEDB.4.0';Data Source='E:\N2C\WorldWideWings\Datenbanken\WorldWideWings.mdb'";
   string CS_Ziel = DemoConfig.CONNSTRING;
   const string SQL_Quelle = "select * from FL_Fluege";
   const string ZIELTABELLE = "FLB_Fluege_Backup";

   // Aufräumen!
   // DE.ITVisions.SADO.Execute("Provider=SQLOLEDB;" + CS_Ziel, "Delete from FL_Fluege_Backup");

   // Verbindung zur Quelle
   Demo.Print("Verbindung zur Quelle öffnen...");
   OleDbConnection C_Quelle = new OleDbConnection(CS_Quelle);
   C_Quelle.Open();
   // Verbindung zum Ziel
   Demo.Print("Verbindung im Ziel öffnen...");
   SqlConnection C_Ziel = new SqlConnection(CS_Ziel);
   C_Ziel.Open();

   // Daten holen
   Demo.Print("Daten aus Quelle einlesen...");
   OleDbCommand CMD_Quelle = new OleDbCommand(SQL_Quelle, C_Quelle);
   OleDbDataReader Reader = CMD_Quelle.ExecuteReader();

   // Kopiervorgang
   Demo.Print("Daten in Zieltabelle schreiben...");
   SqlBulkCopy BulkCopy = new SqlBulkCopy(C_Ziel);
   BulkCopy.DestinationTableName = ZIELTABELLE;
   BulkCopy.WriteToServer(Reader);

   // Ende
   Reader.Close();
   C_Quelle.Close();
   C_Ziel.Close();
  }

  // Massenkopie zwischen SQL Server-Datenbanken mit Optionen
  public void SQLToSQL_Advanced()
  {

   Demo.PrintHeader("Bulk Copy - SQL Server->SQL Server - Erweitert");

   string CS_Quelle = DemoConfig.CONNSTRING;
   string CS_Ziel = DemoConfig.CONNSTRING;
   const string SQL_Quelle = "select * from FL_Fluege";
   const string ZIELTABELLE = "FLB_Fluege_Backup";

   // Verbindung zur Quelle
   Demo.Print("Verbindung zur Quelle öffnen...");
   SqlConnection C_Quelle = new SqlConnection(CS_Quelle);
   C_Quelle.Open();
   // Verbindung zum Ziel
   Demo.Print("Verbindung im Ziel öffnen...");
   SqlConnection C_Ziel = new SqlConnection(CS_Ziel);
   C_Ziel.Open();

   // Daten holen
   Demo.Print("Daten aus Quelle einlesen...");
   SqlCommand CMD_Quelle = new SqlCommand(SQL_Quelle, C_Quelle);
   SqlDataReader Reader = CMD_Quelle.ExecuteReader();

   // Kopiervorgang
   Demo.Print("Daten in Zieltabelle schreiben...");
   SqlBulkCopy BulkCopy = new SqlBulkCopy(C_Ziel);
   BulkCopy.DestinationTableName = ZIELTABELLE;

   BulkCopy.ColumnMappings.Add("FL_Abflugort", "FL_ZielOrt");
   BulkCopy.ColumnMappings.Add("FL_ZielOrt", "FL_Abflugort");
   BulkCopy.NotifyAfter = 200;
   BulkCopy.SqlRowsCopied += new SqlRowsCopiedEventHandler(BulkCopy_SqlRowsCopied);
   BulkCopy.WriteToServer(Reader);

   // Ende
   Reader.Close();
   C_Quelle.Close();
   C_Ziel.Close();

  }

  // Ereignisbehandlung
  static void BulkCopy_SqlRowsCopied(object sender, SqlRowsCopiedEventArgs e)
  {
   Demo.Print("Zeile kopiert: " + e.RowsCopied);
  }
 }
}

// Add.ons:
//  Demo.Print("Datensätze im Ziel vorher: " + DE.ITVisions.SADO.GetTable("Provider=SQLOLEDB;" + CS_Ziel, "Select *from FL_Fluege_Backup").Rows.Count);
