﻿#region Using directives
using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using de.ITVisions.DemoViewer;
#endregion


// .NET Framework 2.0 Demos
// (C) Dr. Holger Schwichtenberg
// http://www.dotnetframework.de
// =====================================

#region Regelwerk

//The SqlNotificationRequest/SqlDependency's SELECT statement must follow the rules for statements that can be used in SQL Server Indexed Views. This is because the NotificationRequest architecture uses the same mechanism as indexed views to deduce when a row in a resultset has changed. Here are  the rules for indexed views:
//
// The select list cannot use the * or table_name.* syntax to specify columns.  
// Column names must be explicitly stated. 
// Table names must be qualified with two part names. No 3 or 4 part names can be used. 
// A table column name used as a simple expression cannot be specified more than once. 
// No derived tables. 
// No rowset functions. 
// No UNION operator. 
// No subqueries. 
// No outer or self joins. 
// No TOP clause.  
// No DISTINCT keyword. 
// No COUNT(*) aggregate. 
// No AVG, MAX, MIN, STDEV, STDEVP, VAR, or VARP aggregates 
// No User Defined Aggregates 
// No SUM function that references a nullable expression 
// No full-text predicates that CONTAINS or FREETEXT. 
// No COMPUTE or COMPUTE BY clause 
// If GROUP BY is not specified, the select list cannot contain aggregate expressions 
// If GROUP BY is specified, the select list must contain a COUNT_BIG(*) expression, and cannot specify HAVING, CUBE, or ROLLUP 
// Must not reference table variables 
// Must not reference any other views or inlineable table-valued functions. 
// Must not reference any system tables or views 
// Must not reference any non-deterministic function – including ranking/windowing functions 
// Must not references any system session (@@) variables  
// Must reference some base table or view 
// No INTO clause 
// Must not specify FOR BROWSE (or be running with SET NO_BROWSETABLE ON) 
// No conditions that will preclude results from changing (e.g. WHERE 1=0) 
// Can not specify READPAST locking hint.  
// Must not reference any Service Broker QUEUE 
//
//  
#endregion

namespace NET2.ADONET
{
  [Demo]
  public class Notifications_Demos
  {
   
   #region Eigenständiges Beispiel
   private static SqlDependency dep = null, dep2 = null;

   static bool DataChanged = false;

   // === Warten auf Datenänderungen in der Flug-Tabelle
   public void run()
   {
    Console.WriteLine("Überwachung der Flugliste [Query Notifications]");

    string CONNSTRING = System.Configuration.ConfigurationManager.ConnectionStrings["WorldWideWingsConnectionString_SQLExpress"].ConnectionString;

    const string SQL = "Select FL_FlugNr,Fl_Abflugort, FL_Zielort, Fl_Plaetze, Fl_FreiePlaetze from dbo.FL_Fluege where FL_zielort = 'Berlin'";

    // Verbindung aufbauen

    while (true)
    {
     DataChanged = false;
     // Befehl definieren
     SqlCommand cmd = GetDep(CONNSTRING, SQL);

     Console.WriteLine("SQLDependency definiert für " + SQL);
     // Ereignisbehandlung binden
     dep.OnChange += new OnChangeEventHandler(dep_OnChange);

     // Befehl ausführen
     Console.WriteLine("Aktuelle Daten werden eingelesen...");
     SqlDataReader r = cmd.ExecuteReader();
     Demo.PrintReader(r);
     cmd = null;

     // Warten!!
     while (!DataChanged)
     { System.Threading.Thread.Sleep(1000); Console.Write("."); }
    }

    //TODO: SqlDependency.Stop(connectionstring);
   }

   private static SqlCommand GetDep(string CONNSTRING, string SQL)
   {
    SqlDependency.Start(CONNSTRING); // Neu. Erst kurz vor RTM! siehe 
    SqlConnection conn = new SqlConnection(CONNSTRING);
    conn.Open();
    SqlCommand cmd = new SqlCommand(SQL, conn);
    dep = new SqlDependency(cmd);
    Console.WriteLine("DEP-ID: " + dep.Id);
    return cmd;
   } 
   
   #endregion
  
    // Ereignisbehandlung für geänderte Daten
    static void dep_OnChange(object sender, SqlNotificationEventArgs e)
    {
      if (e.Type == SqlNotificationType.Subscribe)
      {
        Console.WriteLine("Fehler: " + e.Info.ToString());
      }
      else
      {
        Console.BackgroundColor = ConsoleColor.Cyan;
        Console.WriteLine("\nDaten haben sich geändert!");
        Console.BackgroundColor = ConsoleColor.Black;
        Console.WriteLine("Typ: " + e.Type.ToString());
        Console.WriteLine("Quelle: " + e.Source.ToString());
        Console.WriteLine("Info: " + e.Info.ToString());
        DataChanged = true;
      }
    }


    //#region Test der WWWings DAL
    //de.WWWings.DAL.Flug_DataManager2 FDM = new de.WWWings.DAL.Flug_DataManager2();

    //public void run2()
    //{
    // Console.WriteLine("Überwachung der Flugliste [Query Notifications]");
    // FDM.AktualisierungenMelden("Berlin");
    // FDM.FluegeWurdenAktualisiert += new de.WWWings.DAL.Flug_DataManager2.FluegeWurdenAktualisiertHandler(FDM_FluegeWurdenAktualisiert);
    // Console.ReadLine();
    //}

    //void FDM_FluegeWurdenAktualisiert()
    //{
    // Console.WriteLine("UPDATE!");
    //}
    //#endregion
  }

}