﻿#region Using directives

using System;
using System.Collections.Generic;
using System.Text;

#endregion

using System.DirectoryServices;
using System.DirectoryServices.ActiveDirectory;
using de.ITVisions.DemoViewer;

namespace NET2.FCL
{

 [Demo]
 public class ActiveDirectory
 {

  public void DomänenInfos()
  {
   // Aktuelle Domain ermitteln
   Domain d = System.DirectoryServices.ActiveDirectory.Domain.GetCurrentDomain();

   // Informationen über aktuelle Domäne
   Demo.Print("Name: " + d.Name);
   Demo.Print("Domain Mode: " + d.DomainMode);
   Demo.Print("Inhaber der InfrastructureRole: " + d.InfrastructureRoleOwner.Name);
   Demo.Print("Inhaber der PdcRole: " + d.PdcRoleOwner.Name);
   Demo.Print("Inhaber der PdcRole: " + d.PdcRoleOwner.Name);

   // Informationen über Forest der aktuellen Domäne
   Forest f = d.Forest;
   Demo.Print("Name des Forest: " + f.Name);
   Demo.Print("Modus des Forest: " + f.ForestMode);
  }

  // Alle DC ausgeben
  public void DomaenenController()
  {
   // Aktuelle Domain ermitteln
   DirectoryContext dc = new DirectoryContext(DirectoryContextType.Domain, "LDAP://dc=it-objects,dc=net");
   Domain d = System.DirectoryServices.ActiveDirectory.Domain.GetDomain(dc);
   DomainControllerCollection DCs = d.DomainControllers;
   // Schleife über alle Domänencontroller
   foreach (DomainController DC in DCs)
   {
    Demo.Print("Name: " + DC.Name);
    Demo.Print("IP: " + DC.IPAddress.ToString());
    Demo.Print("Zeit: " + DC.CurrentTime.ToString());
    Demo.Print("Rollen:");
    // Schleife über alle Rollen des DC
    foreach (ActiveDirectoryRole R in DC.Roles)
    {
     Demo.Print("- " + R.ToString());
    }
   }
  }
 }
}
