﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;
using de.ITVisions.DemoViewer;

namespace NET2.FCL
{
  [Demo]
  class ConfigurationDemos
  {

    // Lesen aller Inhalte der Sektionen <appSettings> und <connectionStrings>
    public void Config_LesenAlle()
    {
      Demo.PrintHeader("Liste aller Anwendungseinstellungen:");
      // --- Liste aller Anwendungseinstellungen
      foreach (string aset in ConfigurationManager.AppSettings)

      {
        Demo.Print(aset + " = " + ConfigurationManager.AppSettings[aset]);
      }

      Demo.PrintHeader("Liste aller Verbindungszeichenfolgen:");
      // --- Liste aller Verbindungszeichenfolgen
      foreach (ConnectionStringSettings cset in ConfigurationManager.ConnectionStrings)
      {
        Demo.Print(cset.Name + " = " + cset.ConnectionString);
      }
    }

    public void Config_LesenEinzelne()
    {
      Demo.PrintHeader("Einzelne Einstellungen:");
      string MailServer = ConfigurationManager.AppSettings["Mailserver"];
      string WWWSQLDatenbank = ConfigurationManager.ConnectionStrings["WWWDatenbank_MSSQL"].ConnectionString;
      string WWWAccessDatenbank = ConfigurationManager.ConnectionStrings["WWWDatenbank_Access"].ConnectionString;
      Demo.Print("Mailserver: " + MailServer);
      Demo.Print("Verbindungszeichenfolge 1: " + WWWSQLDatenbank);
      Demo.Print("Verbindungszeichenfolge 2: " + WWWAccessDatenbank);
    }
   
    // Auflisten aller Sektion der Anwendungskonfigurationsdatei
    public void Anwendungskonfig_Lesen()
    {
      // --- Zugriff auf machine.config
      Configuration mc = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
      Demo.Print("Datei liegt hier: " + mc.FilePath);
      Demo.Print("Computerebene?: " + mc.EvaluationContext.IsMachineLevel);
      Demo.Print("HostingContext?: " + mc.EvaluationContext.HostingContext);
      // --- Liste der Sektionen in der machine.config
      foreach (ConfigurationSection s in mc.Sections)
      {
        Demo.Print("Sektion: " + s.SectionInformation.Name);
        Demo.Print("   Schreibschutz?: " + s.SectionInformation.IsLocked);
        Demo.Print("   Verschlüsselt?: " + s.SectionInformation.IsProtected);
      }
    }


    // Auflisten aller Sektion der maschine.config
    public void MaschineConfig_Lesen()
    {
      // --- Zugriff auf machine.config
      Configuration mc = ConfigurationManager.OpenMachineConfiguration();
      Demo.Print("machine.config liegt hier: " + mc.FilePath);
      Demo.Print("Computerebene?: " + mc.EvaluationContext.IsMachineLevel);
      Demo.Print("HostingContext?: " + mc.EvaluationContext.HostingContext);
      // --- Liste der Sektionen in der machine.config
      foreach (ConfigurationSection s in mc.Sections)
      {
     
        Demo.Print("Sektion: " + s.SectionInformation.Name);
        Demo.Print("   Schreibschutz?: " + s.SectionInformation.IsLocked);
        Demo.Print("   Verschlüsselt?: " + s.SectionInformation.IsProtected);
      }
    }

    // Verändern einer Anwendungskonfigurationsdatei
    public void Config_Schreiben()
    {
      // --- Ändern einer Einstellung
      Configuration c = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
      ConfigurationSection aset = c.GetSection("appSettings");
      ConfigurationManager.AppSettings["Mailserver"] = "Bochum";
      c.Save(ConfigurationSaveMode.Full);
      Demo.Print("Mailserver nun: " + ConfigurationManager.AppSettings["Mailserver"]);
    }

    public void Config_Verschlueseln()
    {

      Demo.Print("Zugriff auf Sektion...");
      Configuration c = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
      ConfigurationSection s = c.GetSection("connectionStrings");

      Demo.Print("   Name: " + s.SectionInformation.Name);
      Demo.Print("   Verschlüsselt?: " + s.SectionInformation.IsProtected);
      if (!s.SectionInformation.IsProtected)
      {
        Demo.Print("Verschlüsseln...");
        s.SectionInformation.ProtectSection(ProtectedConfiguration.DataProtectionProviderName);
      }
      else
      {
        Demo.Print("Entschlüsseln...");
        s.SectionInformation.UnprotectSection();

      }
      c.Save();
      Demo.Print("Kontrolle...");
      Configuration c2 = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.None);
      ConfigurationSection s2 = c2.GetSection("connectionStrings");
      Demo.Print("   Name: " + s2.SectionInformation.Name);
      Demo.Print("   Verschlüsselt?: " + s2.SectionInformation.IsProtected);
      Demo.Print("Nutzen...");
      string WWWAccessDatenbank = ConfigurationManager.ConnectionStrings["WWWDatenbank_MSSQL"].ConnectionString;
      Demo.Print("Verbindungszeichenfolge: " + WWWAccessDatenbank);
      Demo.Print("Fertig! :-)");
    }

    //public void SettingsDemos()
    //{

    //  NET2.Properties.Settings s = new NET2.Properties.Settings();
    //  s.AnzahlAufrufDiesesBenutzers++;
    //  //s.AnzahlProgrammAufrufe++;
    //  s.Save();


    //  Demo.Print("Anzahl Programmaufrufe aller Nutzers: " + s.AnzahlProgrammAufrufe.ToString());
    //  Demo.Print("Anzahl Programmaufrufe dieses Nutzer: " + s.AnzahlAufrufDiesesBenutzers.ToString());

    //  Demo.Print("Hier liegt die benutzerspezifische Konfigurationsdatei: " + System.Windows.Forms.Application.LocalUserAppDataPath);
    //}
  }
}
