﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Security.AccessControl;
using de.ITVisions.DemoViewer;
using System.IO;
using System.Security;

namespace NET2.FCL
{
 [Demo]
 class Security
 {

  // === Ausgabe eines Secure String
  public void SecureStringRueckumwandlung()
  {
   SecureString s = new SecureString();
   s.AppendChar('g');
   s.AppendChar('e');
   s.AppendChar('h');
   s.AppendChar('e');
   s.AppendChar('i');
   s.AppendChar('m');
   s.MakeReadOnly();

   IntPtr p = System.Runtime.InteropServices.Marshal.SecureStringToBSTR(s);
   string KlartextKennwort = System.Runtime.InteropServices.Marshal.PtrToStringUni(p);
   Demo.Print(KlartextKennwort);
  }

  // === Liste der bekannten SID
  public void ListeDerWellKnownSIDs()
  {
   Demo.Print("Adminstrator: " + System.Security.Principal.WellKnownSidType.AccountAdministratorSid.ToString());
   Demo.Print("Terminal Server-Benutzer: " + System.Security.Principal.WellKnownSidType.TerminalServerSid.ToString());
   Demo.Print("Gast: " + System.Security.Principal.WellKnownSidType.AccountGuestSid.ToString());

   Demo.Print("Domänen-Administratoren: " + new System.Security.Principal.SecurityIdentifier("DA").Value);
   Demo.Print("Administrator: " + new System.Security.Principal.SecurityIdentifier("LA").Value);
   Demo.Print("Jeder: " + new System.Security.Principal.SecurityIdentifier("WD").Value);
   //Demo.Print("Adminstrator: " + new System.Security.Principal.SecurityIdentifier(System.Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, new System.Security.Principal.SecurityIdentifier(dsd,).Value);
   Demo.Print("Adminstratoren: " + new System.Security.Principal.SecurityIdentifier(System.Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, null).Value);
   Demo.Print("Adminstratoren: " + new System.Security.Principal.SecurityIdentifier("BA").Value);
  }

  public void GetSID()
  {
   const string BENUTZER = @"d64\hs";

   // Umwandlung zwischen Kontenname und SID
   System.Security.Principal.NTAccount Name = new System.Security.Principal.NTAccount(BENUTZER);
   System.Security.Principal.SecurityIdentifier SID = (System.Security.Principal.SecurityIdentifier)
     Name.Translate(typeof(System.Security.Principal.SecurityIdentifier));

   // Umwandlung zwischen SID und Kontenname
   Demo.Print("Name: " + Name.Value + " = SID " + SID.Value);

   Name = (System.Security.Principal.NTAccount)SID.Translate(typeof(System.Security.Principal.NTAccount));
   Demo.Print("SID: " + SID.Value + " = Name " + Name.Value);
  }


  // Hinzufügen von ACEs
  public void SDErgaenzen()
  {

   const string DATEI = @"c:\HolgerSchwichtenberg.doc";

   // Hole ACL
   FileSecurity objFS = File.GetAccessControl(DATEI);

   // ACE erzeugen
   FileSystemAccessRule rule = new FileSystemAccessRule(
   new System.Security.Principal.NTAccount(@"d64\hs"), FileSystemRights.Modify,
   AccessControlType.Deny);

   FileSystemAccessRule rule2 = new FileSystemAccessRule(
new System.Security.Principal.SecurityIdentifier(System.Security.Principal.WellKnownSidType.BuiltinAdministratorsSid, null), FileSystemRights.FullControl,
AccessControlType.Allow);

   // Regel hinzufügen
   objFS.AddAccessRule(rule);
   objFS.AddAccessRule(rule2);

   // Speichern
   File.SetAccessControl(DATEI, objFS);
  }


  // Auslesen einer Datei-ACL
  public void SDAuslesen()
  {
   const string DATEI = @"c:\HolgerSchwichtenberg.doc";

   // Hole ACL
   FileSecurity objFS = File.GetAccessControl(DATEI);

   // Besitzer
   Demo.Print("Besitzer SID: " + objFS.GetOwner(typeof(System.Security.Principal.SecurityIdentifier)).Value);
   Demo.Print("Besitzer Name: " + objFS.GetOwner(typeof(System.Security.Principal.NTAccount)).Value);

   // Hole einzelne ACEs aus ACL
   AuthorizationRuleCollection ACEs = objFS.GetAccessRules(true, true, typeof(System.Security.Principal.NTAccount));

   // Schleife über alle ACEs
   foreach (FileSystemAccessRule ACE in ACEs)
   {
    Console.WriteLine("Benutzer/Gruppe {0}: {1} {2} ({3})",
     ACE.IdentityReference.ToString(),
     ACE.FileSystemRights,
     ACE.AccessControlType == AccessControlType.Allow ? "zugelassen" : "verweigert",
     ACE.IsInherited ? "vererbt" : "explizit"
     );
   }
  }
 }
}

