Imports System
Imports System.Web.UI
Imports System.Web.UI.Design
Imports System.Web.UI.WebControls
Imports System.ComponentModel

Public Class BeschrifteteTextBox2
  Inherits WebControl

  ' === Die Beschriftung 

  <Description("Die Beschriftung der Textbox"), _
  Category("Darstellung")> _
  Public Property Beschriftung() As String
    Get
      Dim C_BeschriftungsText As String = CStr(ViewState("Beschriftung"))
      If C_BeschriftungsText Is Nothing Then
        Return String.Empty
      End If
      Return C_BeschriftungsText
    End Get
    Set(ByVal Value As String)
      ViewState("Beschriftung") = Value
    End Set
  End Property

  ' === Das Aussehen der Beschriftung
  <Description("Die Cascading StyleSheet Klasse fr die Beschriftung"), _
  Category("Darstellung")> _
  Public Property BeschriftungsStyle() As String
    Get
      Dim C_BeschriftungsStyle As String = CStr(ViewState("BeschriftungsStyle"))
      If C_BeschriftungsStyle Is Nothing Then
        Return String.Empty
      End If
      Return C_BeschriftungsStyle
    End Get
    Set(ByVal Value As String)
      ViewState("BeschriftungsStyle") = Value
    End Set
  End Property

  ' === Ausrichtungsarten
  Enum Ausrichtung As Byte
    Links
    Oben
    Rechts
    Unten
  End Enum

  ' === Ausrichtung des Labels
  <Description("Die Ausrichtung der Beschriftung im Verhltnis zur TextBox"), _
  Category("Darstellung"), _
  DefaultValue("Links")> _
  Public Property BeschriftungsAusrichtung() As Ausrichtung
    Get
      Dim C_BeschriftungsAusrichtung As Ausrichtung = CType(ViewState("BeschriftungsAusrichtung"), Ausrichtung)
      Return C_BeschriftungsAusrichtung
    End Get
    Set(ByVal Value As Ausrichtung)
      ViewState("BeschriftungsAusrichtung") = Value
    End Set
  End Property

  ' === Die TextBox
  <Description("Der Text der TextBox"), _
  Category("Darstellung")> _
  Public Property TextBoxText() As String
    Get
      Dim C_TextBoxText As String = CStr(ViewState("TextBoxText"))
      If C_TextBoxText Is Nothing Then
        Return String.Empty
      End If
      Return C_TextBoxText
    End Get
    Set(ByVal Value As String)
      ViewState("TextBoxText") = Value
    End Set
  End Property

  ' === Der Style der TextBox
  <Description("Der Style der TextBox"), _
  Category("Darstellung")> _
  Public Property TextBoxStyle() As String
    Get
      Dim C_TextBoxStyle As String = CStr(ViewState("TextBoxStyle"))
      If C_TextBoxStyle Is Nothing Then
        Return String.Empty
      End If
      Return C_TextBoxStyle
    End Get
    Set(ByVal Value As String)
      ViewState("TextBoxStyle") = Value
    End Set
  End Property

  ' === berschreiben der CreateChildMethode
  Protected Overrides Sub CreateChildControls()
    MyBase.CreateChildControls()

    ' --- Erstellen der Beschriftung
    Dim C_Beschriftung As New Label()
    C_Beschriftung.Text = Beschriftung
    If BeschriftungsStyle <> "" Then
      C_Beschriftung.CssClass = BeschriftungsStyle
    End If

    ' --- Erstellen der TextBox
    Dim C_TextBox As New TextBox()
    C_TextBox.Text = TextBoxText
    If TextBoxStyle <> "" Then
      C_TextBox.CssClass = TextBoxStyle
    End If

    If BeschriftungsAusrichtung = Ausrichtung.Links Then
      ' --- Beschriftung wird links ausgegeben

      ' --- 1. Steuerelement : Beschriftung
      Controls.Add(C_Beschriftung)
      ' --- 2. Steuerelement : Leerzeichen
      Controls.Add(New LiteralControl(" "))
      ' --- 3. Steuerelement : Textbox
      Controls.Add(C_TextBox)

    ElseIf BeschriftungsAusrichtung = Ausrichtung.Oben Then
      ' --- Beschriftung wird oben ausgegeben

      ' --- 1. Steuerelement : Beschriftung
      Controls.Add(C_Beschriftung)
      ' --- 2. Steuerelement : Zeilenumbruch
      Controls.Add(New LiteralControl("<br>"))
      ' --- 3. Steuerelement : Textbox
      Controls.Add(C_TextBox)

    ElseIf BeschriftungsAusrichtung = Ausrichtung.Unten Then
      ' --- Beschriftung wird unten ausgegeben

      ' --- 1. Steuerelement : Textbox
      Controls.Add(C_TextBox)
      ' --- 2. Steuerelement : Zeilenumbruch
      Controls.Add(New LiteralControl("<br>"))
      ' --- 3. Steuerelement : Beschriftung
      Controls.Add(C_Beschriftung)

    ElseIf BeschriftungsAusrichtung = Ausrichtung.Rechts Then
      ' --- Beschriftung wird rechts ausgegeben

      ' --- 1. Steuerelement : Textbox
      Controls.Add(C_TextBox)
      ' --- 2. Steuerelement : Leerzeichen
      Controls.Add(New LiteralControl(" "))
      ' --- 3. Steuerelement : Beschriftung
      Controls.Add(C_Beschriftung)

    End If

  End Sub

  Protected Overrides Sub Render(ByVal Ausgabe As HtmlTextWriter)

    RenderChildren(Ausgabe)

  End Sub

End Class
