using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI.Fenster
{
 public partial class F_Flugliste_MitAktualisierung : Form
 {
  public F_Flugliste_MitAktualisierung()
  {
   InitializeComponent();
  }

  private void bindingNavigatorSaveItem_Click(object sender, EventArgs e)
  {
   if (this.Validate())
   {
    this.fL_FluegeBindingSource.EndEdit();
    this.fL_FluegeTableAdapter.Update(this.dataset_WorldWideDings2_SQLExpress_NonXCopy.FL_Fluege);
   }
   else
   {
    System.Windows.Forms.MessageBox.Show(this, "Validation errors occurred.", "Save", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Warning);
   }
  }
  de.WWWings.DAL.Flug_DataManager2 FDM = new de.WWWings.DAL.Flug_DataManager2();
  
  private void F_Flugliste_MitAktualisierung_Load(object sender, EventArgs e)
  {
   GetData();
   SetWatch();
  }

  void SetWatch()
  {
   FDM.AktualisierungenMelden("Berlin");
   FDM.FluegeWurdenAktualisiert += new de.WWWings.DAL.Flug_DataManager2.FluegeWurdenAktualisiertHandler(FDM_FluegeWurdenAktualisiert);
  }

  void FDM_FluegeWurdenAktualisiert()
  {
   GetData();
   SetWatch();
  }

  private void C_refresh_Click(object sender, EventArgs e)
  {
   GetData();
  }

  public delegate void GetDataAsyncDelegate();

  private void GetData()
  {
  GetDataAsyncDelegate d = new GetDataAsyncDelegate(GetDataAsync);
   this.Invoke(d, new object[] {});
 }
 
  private void GetDataAsync()
  {
   this.fL_FluegeTableAdapter.ClearBeforeFill = true;
   this.fL_FluegeTableAdapter.Fill(this.dataset_WorldWideDings2_SQLExpress_NonXCopy.FL_Fluege);
   this.C_LetzteAktualisierung.Text = "Letzte Aktualisierung : " + DateTime.Now.ToLongTimeString();
  }

  private void fL_FluegeDataGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
  {

  }

  private void fL_FluegeBindingNavigator_RefreshItems(object sender, EventArgs e)
  {

  }


 }
}