﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI
{
	public partial class F_Hauptmenu : Form
	{
		public F_Hauptmenu()
		{
			InitializeComponent();
		}


		private void SetStatus()
		{

			this.C_Benutzername.Text = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
			this.C_Anmeldungen.Text = WindowsUI.Properties.Settings.Default.AnzahlAufrufeDiesesNutzers.ToString();
			this.C_LetzteAnmeldung.Text = WindowsUI.Properties.Settings.Default.LetzterAufruf.ToString();
			this.C_Sprache.Text = System.Threading.Thread.CurrentThread.CurrentUICulture.NativeName;
			this.C_StyleInfo.Text = System.Windows.Forms.VisualStyles.VisualStyleInformation.DisplayName + ";" + System.Windows.Forms.VisualStyles.VisualStyleInformation.Company;

			this.C_StatusBenutzer.Text = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
			this.C_StatusSprache.Text = System.Threading.Thread.CurrentThread.CurrentUICulture.NativeName;
		}

		private void Hauptmenu_Load(object sender, EventArgs e)
		{


			WindowsUI.Properties.Settings.Default.AnzahlAufrufeDiesesNutzers += 1;
			WindowsUI.Properties.Settings.Default.LetzterAufruf = System.DateTime.Now;
			WindowsUI.Properties.Settings.Default.Save();

			System.Media.SystemSounds.Beep.Play();

			SetStatus();
		}

		private void Hauptmenu_FormClosed(object sender, FormClosedEventArgs e)
		{
			//Application.Exit();
		}

		private void button1_Click(object sender, EventArgs e)
		{
			this.Controls["GroupBox1"].BackColor = Color.Azure;
			this.Controls[0].BackColor = Color.Azure;
		}

		private void F_Hauptmenu_Load(object sender, EventArgs e)
		{

		}

		private void ticketdruckenToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Demos().TicketDruck();
		}



		private void windowsSpracheToolStripMenuItem_Click(object sender, EventArgs e)
		{
			System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("de-DE");
			   this.FormularNeuZeichnen();
   SetStatus();

   this.englischToolStripMenuItem.Checked = false;
   this.deutschToolStripMenuItem.Checked = true;  
		}

  private void FormularNeuZeichnen()
  {
   this.Controls.Clear();
   
   this.InitializeComponent();
  }


		private void englischToolStripMenuItem_Click(object sender, EventArgs e)
		{
		
			System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("en-GB");
			SetStatus();
   //C_Notify.Icon = new Icon("worlwidewings.ico");
   //C_Notify.Visible = true;
   //C_Notify.Text = "Sprache wurde geändert!";
   this.FormularNeuZeichnen();
   this.deutschToolStripMenuItem.Checked = false;
   this.englischToolStripMenuItem.Checked = true;
  
  }

		private void fluglistepflegenToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Fenster.F_Flugverwaltung_RAD_TDS().Show();
		}

		private void fluglistemanuelleDatenbindungToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Fenster.F_Flugverwaltung_Manuell().Show();
		}

		private void mitarbeiterzuordnungToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void buchungslisteToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new F_Buchungsverwaltung().ShowDialog();
		}

		private void mDIAnsichtToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new F_MDI().Show();
		}

		private void xPVisualStylesToolStripMenuItem_Click(object sender, EventArgs e)
		{
			xPVisualStylesToolStripMenuItem.Checked = !xPVisualStylesToolStripMenuItem.Checked;
			if (xPVisualStylesToolStripMenuItem.Checked)
			{
				Application.EnableVisualStyles();
			}
			else
			{
				Application.EnableVisualStyles();
			}



		}

		private void aToolStripMenuItem_Click(object sender, EventArgs e)
		{

			System.Media.SoundPlayer p = new System.Media.SoundPlayer();
			p.SoundLocation = @"..\..\Media\a.wav";
			p.Play();

		}

		private void hToolStripMenuItem_Click(object sender, EventArgs e)
		{

			System.Media.SoundPlayer p = new System.Media.SoundPlayer();
			p.SoundLocation = @"..\..\Media\h.wav";
			p.Play();

		}

		private void flowToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Fenster.F_FlowLayoutTest().ShowDialog();
		}

		private void tableToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Fenster.F_TableLayoutTest().ShowDialog();
		}

		private void benutzerdefDatenbindungToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Fenster.F_Binding().ShowDialog();
		}

		private void passagierpflegeObjektbindungToolStripMenuItem_Click(object sender, EventArgs e)
		{
			new Fenster.F_ObjektBindung().ShowDialog();
		}

		private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
		{
			// This method will run on a thread other than the UI thread.
			// Be sure not to manipulate any Windows Forms controls created
			// on the UI thread from this method.

		}

		private void backgroundWorkerToolStripMenuItem_Click(object sender, EventArgs e)
		{
			this.backgroundWorker1.RunWorkerAsync();
		}

		private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
		{
			System.Windows.Forms.MessageBox.Show("Ich habe fertig!");
		}

		private void bewertungenToolStripMenuItem_Click(object sender, EventArgs e)
		{

		}

		private void toolStripButton1_Click(object sender, EventArgs e)
		{

		}

    private void userLevelToolStripMenuItem_Click(object sender, EventArgs e)
    {
      new Fenster.F_UserLevelKonfig().ShowDialog();
    }

    private void beendenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      DialogResult a = System.Windows.Forms.MessageBox.Show("Wollen Sie die Anwendung wirklich beenden?", Application.ProductName, MessageBoxButtons.YesNo);
      if (a == DialogResult.Yes)
      {
        Application.Exit();
      }
    }

    private void berichtdruckenToolStripMenuItem_Click(object sender, EventArgs e)
    {
      new Fenster.F_Flugberichtansicht().Show();
    }

    private void berichtdruckenMSReportsToolStripMenuItem_Click(object sender, EventArgs e)
    {
      new Fenster.F_Flugberichtansicht_MSReports().Show();
    }

  private void anzeigeEingehendeFluegeToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugliste_MitAktualisierung().Show();
  }

  private void groupBox1_Enter(object sender, EventArgs e)
  {

  }

  private void hilfeToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void tableLayoutToolStripMenuItem_Click(object sender, EventArgs e)
  {

  }

  private void fluglisteObjektdatenbindungToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugverwaltung_Object().Show();
  }

  private void fluglisteWebserviceToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new F_Flugverwaltung_Webservice().Show();
  }

  private void fluglisteMitDetailansichtRADTypedDataSetToolStripMenuItem_Click(object sender, EventArgs e)
  {
   new Fenster.F_Flugverwaltung_mit_Details_RAD_TDS().Show();
  }		

	}


}
