﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WindowsUI
{
 public partial class F_Ticketdruck : Form
 {
  public F_Ticketdruck()
  {
   InitializeComponent();
  }


  void TicketZeichnen(Graphics g)
  {
   g.DrawRectangle(new Pen(Brushes.Black, 3), 20 + g.VisibleClipBounds.X, 20 + g.VisibleClipBounds.Y, g.VisibleClipBounds.X + 700, 200);
   g.FillRectangle(Brushes.LightYellow, 21 + g.VisibleClipBounds.X, 21 + g.VisibleClipBounds.Y, g.VisibleClipBounds.X + 699, 199);
   Image i = Image.FromFile(Application.StartupPath + "\\WorldWideWings_Logo.jpg");
   g.DrawImage(i, 50, 40, 280, 100);

   g.DrawString("Flugticket Nr. " + Buchung.TicketNummer, new Font("Arial", 25.0f), Brushes.Blue, 390, 40);
   g.DrawString("Passagier: " + Buchung.Passagier.GanzerName, new Font("Arial", 12f), Brushes.Black, 400, 100);
   g.DrawString("von: " + Buchung.Flug.AbflugOrt, new Font("Arial", 12f), Brushes.Black, 400, 130);
   g.DrawString("nach: " + Buchung.Flug.ZielOrt, new Font("Arial", 12f), Brushes.Black, 400, 160);
   g.DrawString("Datum: " + Buchung.Flug.Datum.ToShortDateString(), new Font("Arial", 12f), Brushes.Black, 400, 190);
   g.FillPie(Brushes.Salmon, 630, 130, 80, 80, -90, 90);
   g.DrawEllipse(new Pen(Brushes.Black, 2), 630, 130, 80, 80);
   g.DrawString(Buchung.Klasse, new Font("Arial", 16f, FontStyle.Bold), Brushes.White, 670, 140);
  }

  private void F_Ticketdruck_Paint(object sender, PaintEventArgs e)
  {
   Graphics g = e.Graphics;
   TicketZeichnen(g);
  }

  private void C_Ticketdruck_Click(object sender, EventArgs e)
  {
   PrintPreviewDialog ppd = new PrintPreviewDialog();
   ppd.Document = this.C_Print;
   if (ppd.ShowDialog() == DialogResult.OK)
   {
    PrintDialog pd = new PrintDialog();
    pd.Document = this.C_Print;
    if (pd.ShowDialog() == DialogResult.OK)
    {
     C_Print.Print();
    }

   }
  }

  private void C_Print_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
  {
   Graphics g = e.Graphics;
   TicketZeichnen(g);
  }

  private void F_Ticketdruck_Load(object sender, EventArgs e)
  {

  }
  public de.WWWings.PassagierSystem.Buchung Buchung;

  private void C_Zwischenablage_Click(object sender, EventArgs e)
  {
   Clipboard.SetText("Flugticket " + Buchung.TicketNummer + "; Name: " + Buchung.Passagier.GanzerName + "; Flug: " + Buchung.Flug.ToString());
  }

  private void C_TicketZwischenablage_Click(object sender, EventArgs e)
  {
   Bitmap b = new Bitmap(750, 250);
   TicketZeichnen(Graphics.FromImage(b));
   Clipboard.SetImage(b);
   b.Dispose();


  }

  private void C_Speichern_Click(object sender, EventArgs e)
  {
   Bitmap b = new Bitmap(750, 250);
   TicketZeichnen(Graphics.FromImage(b));
   SaveFileDialog sfd = new SaveFileDialog();
   sfd.Filter = "Bitmap (.bmp) | *.bmp";
   sfd.FileName = "Ticket.bmp";
   sfd.InitialDirectory = "c:\\";
   if (sfd.ShowDialog() == DialogResult.OK)
   {
    b.Save("c:\\ticket.bmp");
   }
   b.Dispose();
  }
 }
}