package addressbook.web;

import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;
import java.util.Locale;

/**
 * Konverter, der {@link java.util.Locale}s in eine Stringdarstellung überführt
 * (z.B. "de_DE") und umgekehrt.
 *
 * @see Locale#toString
 */
public class LocaleConverter implements Converter {

  public Object getAsObject(
      FacesContext facesContext, UIComponent component, String value) {
    Locale locale = createLocale(value);
    if (locale == null) {
      throw new ConverterException("Can't parse " + value + " to a locale.");
    }
    return locale;
  }

  public String getAsString(
      FacesContext facesContext, UIComponent component, Object value) {
    return value == null ? null : value.toString();
  }

  public static Locale createLocale(String value) {
    Locale locale = null;
    String[] strings = value.split("_");
    switch (strings.length) {
      case 1:
        locale = new Locale(strings[0]);
        break;
      case 2:
        locale = new Locale(strings[0], strings[1]);
        break;
      case 3:
        locale = new Locale(strings[0], strings[1], strings[2]);
        break;
    }
    return locale;
  }

}
