<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<html>
<head>
  <title>Address Editor</title>
  <link rel="stylesheet" href="style.css" type="text/css"/>
</head>

<body>
<f:view>
<h:form id="f">
<fieldset>
  <legend><h:outputText value="Address Editor"/></legend>

  <h:panelGrid columns="3">

    <h:outputLabel for="firstName" value="First Name"/>
    <h:inputText id="firstName" value="#{controller.currentAddress.firstName}" required="true"/>
    <h:message for="firstName" styleClass="messages"/>

    <h:outputLabel for="lastName" value="Last Name"/>
    <h:inputText id="lastName" value="#{controller.currentAddress.lastName}" required="true"/>
    <h:message for="lastName" styleClass="messages"/>

    <h:outputLabel for="street" value="Street"/>
    <h:panelGroup>
      <h:inputText id="street" value="#{controller.currentAddress.street}" size="13"/>
      <h:inputText id="houseNumber" value="#{controller.currentAddress.houseNumber}" size="3"/>
    </h:panelGroup>
    <h:panelGroup>
      <h:message for="street" styleClass="messages"/>
      <h:message for="houseNumber" styleClass="messages"/>
    </h:panelGroup>

    <h:outputLabel for="city" value="City"/>
    <h:panelGroup>
      <h:inputText id="zipCode" value="#{controller.currentAddress.zipCode}" size="5"/>
      <h:inputText id="city" value="#{controller.currentAddress.city}" size="11"/>
    </h:panelGroup>
    <h:panelGroup>
      <h:message for="zipCode" styleClass="messages"/>
      <h:message for="city" styleClass="messages"/>
    </h:panelGroup>

    <%-- no label for SELECT because IE changes selection if label is clicked --%>
    <h:outputText value="Country"/>
    <h:selectOneMenu id="country" value="#{controller.currentAddress.country}">
      <f:selectItems value="#{countries}"/>
    </h:selectOneMenu>
    <h:message for="country" styleClass="messages"/>

    <h:outputLabel for="phone" value="Phone"/>
    <h:inputText id="phone" value="#{controller.currentAddress.phone}"/>
    <h:message for="phone" styleClass="messages"/>

    <h:outputLabel for="mobile" value="Mobile"/>
    <h:inputText id="mobile" value="#{controller.currentAddress.mobile}"/>
    <h:message for="mobile" styleClass="messages"/>

    <h:outputLabel for="fax" value="Fax"/>
    <h:inputText id="fax" value="#{controller.currentAddress.fax}"/>
    <h:message for="fax" styleClass="messages"/>

    <h:outputLabel for="email" value="Email"/>
    <h:inputText id="email" value="#{controller.currentAddress.email}"/>
    <h:message for="email" styleClass="messages"/>

    <h:outputLabel for="icq" value="Icq"/>
    <h:inputText id="icq" value="#{controller.currentAddress.icq}"/>
    <h:message for="icq" styleClass="messages"/>

    <h:outputLabel for="homePage" value="Homepage"/>
    <h:inputText id="homePage" value="#{controller.currentAddress.homePage}"/>
    <h:message for="homePage" styleClass="messages"/>

    <h:outputLabel for="dayOfBirth" value="Birthday"/>
    <h:inputText id="dayOfBirth" value="#{controller.currentAddress.dayOfBirth}">
      <f:convertDateTime pattern="dd.MM.yyyy"/>
    </h:inputText>
    <h:message for="dayOfBirth" styleClass="messages"/>

    <h:outputLabel for="company" value="Company"/>
    <h:inputText id="company" value="#{controller.currentAddress.company}"/>
    <h:message for="company" styleClass="messages"/>

    <h:outputLabel for="jobTitle" value="Job Title"/>
    <h:inputText id="jobTitle" value="#{controller.currentAddress.jobTitle}"/>
    <h:message for="jobTitle" styleClass="messages"/>

    <h:outputLabel for="jobPhone" value="Job Phone"/>
    <h:inputText id="jobPhone" value="#{controller.currentAddress.jobPhone}"/>
    <h:message for="jobPhone" styleClass="messages"/>

    <h:outputLabel for="jobEmail" value="Job Email"/>
    <h:inputText id="jobEmail" value="#{controller.currentAddress.jobEmail}"/>
    <h:message for="jobEmail" styleClass="messages"/>

    <h:outputLabel for="jobHomePage" value="Company Homepage"/>
    <h:inputText id="jobHomePage" value="#{controller.currentAddress.jobHomePage}"/>
    <h:message for="jobHomePage" styleClass="messages"/>

    <h:outputLabel for="note" value="Note"/>
    <h:inputTextarea id="note" value="#{controller.currentAddress.note}"/>
    <h:message for="note" styleClass="messages"/>

  </h:panelGrid>

  <h:commandButton action="#{controller.store}" value="Store"/>
  <h:commandButton action="#{controller.cancel}" value="Cancel" immediate="true"/>
</fieldset>
</h:form>
</f:view>
</body>
</html>