package addressbook.web;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.Locale;

/**
 * Liste der verfügbaren Locales.
 */
public class Countries extends ArrayList<SelectItem> {

  public Countries() {
    Locale language = Locale.US;
    Locale[] availableLocales = Locale.getAvailableLocales();
    for (Locale locale : availableLocales) {
      String displayCountry = locale.getDisplayCountry(language);
      if (displayCountry != null && displayCountry.length() > 0) {
        add(new SelectItem(locale, displayCountry));
      }
    }
  }
}
