package addressbook.web;

import addressbook.service.EmailAddress;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

/**
 * Konverter zum Erzeugen einer Emailadresse ohne jegliche Validierung.
 */
public class EmailAddressConverter implements Converter {

  public Object getAsObject(
      FacesContext facesContext, UIComponent component, String reference) {
    if (reference == null || reference.length() == 0) {
      return null;
    }
    return new EmailAddress(reference);
  }

  public String getAsString(
      FacesContext facesContext, UIComponent component, Object object) {
    return object.toString();
  }

}
