package addressbook.web;

import javax.faces.context.FacesContext;
import javax.faces.application.FacesMessage;
import java.util.ResourceBundle;
import java.text.MessageFormat;

/**
 * Hilfsmethoden zum Thema Internationalisierung.
 */
public class MessageUtils {

  private MessageUtils() {
  }

  public static String getLocalizedString(FacesContext facesContext, String key) {
    ResourceBundle bundle = ResourceBundle.getBundle(
        facesContext.getApplication().getMessageBundle(),
        facesContext.getViewRoot().getLocale());
    return bundle.getString(key);
  }

  public static String getLocalizedString(FacesContext facesContext,
      String key, String value) {
    return MessageFormat.format(
        getLocalizedString(facesContext, key), new Object[]{value});
  }

  public static FacesMessage createErrorMessage(
      String key, FacesContext facesContext) {
    FacesMessage message = new FacesMessage();
    message.setDetail(getLocalizedString(facesContext, key));
    message.setSeverity(FacesMessage.SEVERITY_ERROR);
    return message;
  }

}
