<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib tagdir="/WEB-INF/tags" prefix="t" %>


<t:page>
<jsp:body>
<fieldset>
  <legend><h:outputText value="#{bundle.editor_title}"/></legend>

  <h:panelGrid columns="3">

    <h:outputLabel for="firstName" value="#{bundle.editor_first_name}"/>
    <h:inputText id="firstName" value="#{controller.currentAddress.firstName}" required="true">
      <f:validateLength minimum="2" maximum="20"/>
    </h:inputText>
    <h:message for="firstName" styleClass="messages"/>

    <h:outputLabel for="lastName" value="#{bundle.editor_last_name}"/>
    <h:inputText id="lastName" value="#{controller.currentAddress.lastName}" required="true"/>
    <h:message for="lastName" styleClass="messages"/>

    <h:outputLabel for="street" value="#{bundle.editor_street}"/>
    <h:panelGroup>
      <h:inputText id="street" value="#{controller.currentAddress.street}" size="13"/>
      <h:inputText id="houseNumber" value="#{controller.currentAddress.houseNumber}" size="3"/>
    </h:panelGroup>
    <h:panelGroup>
      <h:message for="street" styleClass="messages"/>
      <h:message for="houseNumber" styleClass="messages"/>
    </h:panelGroup>

    <h:outputLabel for="city" value="#{bundle.editor_city}"/>
    <h:panelGroup>
      <h:inputText id="zipCode" value="#{controller.currentAddress.zipCode}" size="5"/>
      <h:inputText id="city" value="#{controller.currentAddress.city}" size="11"/>
    </h:panelGroup>
    <h:panelGroup>
      <h:message for="zipCode" styleClass="messages"/>
      <h:message for="city" styleClass="messages"/>
    </h:panelGroup>

    <%-- no label for SELECT because IE changes selection if label is clicked --%>
    <h:outputText value="#{bundle.editor_country}"/>
    <h:selectOneMenu id="country" value="#{controller.currentAddress.country}">
      <f:selectItems value="#{countries}"/>
    </h:selectOneMenu>
    <h:message for="country" styleClass="messages"/>

    <h:outputLabel for="phone" value="#{bundle.editor_phone}"/>
    <h:inputText id="phone" value="#{controller.currentAddress.phone}"
        validator="#{controller.validatePhoneNumber}"/>
    <h:message for="phone" styleClass="messages"/>

    <h:outputLabel for="mobile" value="#{bundle.editor_mobile}"/>
    <h:inputText id="mobile" value="#{controller.currentAddress.mobile}"
        validator="#{controller.validatePhoneNumber}"/>
    <h:message for="mobile" styleClass="messages"/>

    <h:outputLabel for="fax" value="#{bundle.editor_fax}"/>
    <h:inputText id="fax" value="#{controller.currentAddress.fax}"
        validator="#{controller.validatePhoneNumber}"/>
    <h:message for="fax" styleClass="messages"/>

    <h:outputLabel for="email" value="#{bundle.editor_email}"/>
    <h:inputText id="email" value="#{controller.currentAddress.email}">
      <f:validator validatorId="EmailAddressValidator"/>
    </h:inputText>
    <h:message for="email" styleClass="messages"/>

    <h:outputLabel for="icq" value="#{bundle.editor_icq}"/>
    <h:inputText id="icq" value="#{controller.currentAddress.icq}">
      <f:validateLongRange minimum="0"/>
    </h:inputText>
    <h:message for="icq" styleClass="messages"/>

    <h:outputLabel for="homePage" value="#{bundle.editor_homepage}"/>
    <h:inputText id="homePage" value="#{controller.currentAddress.homePage}"/>
    <h:message for="homePage" styleClass="messages"/>

    <h:outputLabel for="dayOfBirth" value="#{bundle.editor_birthday} (#{bundle.editor_date_pattern})"/>
    <h:inputText id="dayOfBirth" value="#{controller.currentAddress.dayOfBirth}">
      <f:convertDateTime pattern="#{bundle.editor_date_pattern}"/>
    </h:inputText>
    <h:message for="dayOfBirth" styleClass="messages"/>

    <h:outputLabel for="company" value="#{bundle.editor_job_company}"/>
    <h:inputText id="company" value="#{controller.currentAddress.company}"/>
    <h:message for="company" styleClass="messages"/>

    <h:outputLabel for="jobTitle" value="#{bundle.editor_job_title}"/>
    <h:inputText id="jobTitle" value="#{controller.currentAddress.jobTitle}"/>
    <h:message for="jobTitle" styleClass="messages"/>

    <h:outputLabel for="jobPhone" value="#{bundle.editor_job_phone}"/>
    <h:inputText id="jobPhone" value="#{controller.currentAddress.jobPhone}"
        validator="#{controller.validatePhoneNumber}"/>
    <h:message for="jobPhone" styleClass="messages"/>

    <h:outputLabel for="jobEmail" value="#{bundle.editor_job_email}"/>
    <h:inputText id="jobEmail" value="#{controller.currentAddress.jobEmail}"/>
    <h:message for="jobEmail" styleClass="messages"/>

    <h:outputLabel for="jobHomePage" value="#{bundle.editor_job_homepage}"/>
    <h:inputText id="jobHomePage" value="#{controller.currentAddress.jobHomePage}"/>
    <h:message for="jobHomePage" styleClass="messages"/>

    <h:outputLabel for="note" value="#{bundle.editor_note}"/>
    <h:inputTextarea id="note" value="#{controller.currentAddress.note}" rows="3"/>
    <h:message for="note" styleClass="messages"/>

  </h:panelGrid>

  <h:commandButton action="#{controller.store}" value="#{bundle.editor_store}"/>
  <h:commandButton action="#{controller.cancel}" value="#{bundle.editor_cancel}" immediate="true"/>
</fieldset>
</jsp:body>
</t:page>
