<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib tagdir="/WEB-INF/tags" prefix="t" %>

<t:page>
<jsp:body>
  <h:outputLabel for="search" value="#{bundle.list_filter}" />
  <h:inputText id="search" value="#{controller.searchCriterion}"/>

  <h:commandButton action="#{controller.search}" value="#{bundle.list_search}"/>

  <h:dataTable value="#{controller.addressRows}" var="row"
      cellpadding="0" cellspacing="0"
      rowClasses="row-odd,row-even" styleClass="table">
    <f:facet name="footer">
      <h:panelGroup>
        <h:outputFormat value="#{bundle.list_footer}">
          <f:param value="#{controller.addressCount}" />
        </h:outputFormat>
      </h:panelGroup>
    </f:facet>

    <h:column>
      <f:facet name="header">
        <h:outputText value=" "/>
      </f:facet>
      <h:selectBooleanCheckbox value="#{row.selected}" styleClass="checkbox"/>
    </h:column>

    <h:column>
      <f:facet name="header">
        <h:outputText value="#{bundle.list_first_name}"/>
      </f:facet>
      <h:outputText value="#{row.address.firstName}"/>
    </h:column>

    <h:column>
      <f:facet name="header">
        <h:outputText value="#{bundle.list_last_name}"/>
      </f:facet>
      <h:outputText value="#{row.address.lastName}"/>
    </h:column>

  </h:dataTable>

  <h:commandButton action="#{controller.createAddress}" value="#{bundle.list_new}"/>
  <h:commandButton action="#{controller.editAddress}" value="#{bundle.list_edit}"/>
  <h:commandButton action="#{controller.deleteAddresses}" value="#{bundle.list_delete}"
      disabled="#{empty controller.addressRows}"/>
</jsp:body>
</t:page>
