using System;

using Microsoft.Web.Services2;
using Microsoft.Web.Services2.Security;
using Microsoft.Web.Services2.Security.Tokens;
using Microsoft.Web.Services2.Security.X509;

using WSSClient.WSSService;

namespace WSSClient
{
	public class SecureClient
	{
		
		private static String data = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";

		[STAThread]
		static void Main(string[] args)
		{          
			// open certificate store
			X509CertificateStore store = 
				X509CertificateStore.LocalMachineStore(
				X509CertificateStore.MyStore);
			bool open = store.OpenRead();

			// get client signature certificate
			X509CertificateCollection certs =
				store.FindCertificateBySubjectString("Signature");
			X509SecurityToken signingToken = new X509SecurityToken((X509Certificate) certs[0]);

			// get service encryption certificate
			certs = store.FindCertificateBySubjectString("Encryption");
			X509SecurityToken encryptionToken = new X509SecurityToken((X509Certificate) certs[0]);

			double total = 0;
			String echo = data;

			for (int j=0; j<10; j++)
			{			
				
				DateTime start = DateTime.Now;

				// call WSSService operation 
				for (int i=0; i<100; i++)
				{
					// create instance of proxy
					SecureServiceWse wssProxy = new SecureServiceWse();
					SoapContext requestContext = wssProxy.RequestSoapContext;

					requestContext.Security.Tokens.Add(signingToken);
					requestContext.Security.Elements.Add(new MessageSignature(signingToken));
					requestContext.Security.Elements.Add(new EncryptedData(encryptionToken));
					
					String result = wssProxy.SecureEcho(echo);
				}

				DateTime end = DateTime.Now;			
				TimeSpan ts = end - start;

				double differenceInMillis = ts.TotalMilliseconds;
				
				Console.WriteLine("Duration: " + ts.Hours + ":" + ts.Minutes + ":" + ts.Seconds + ":" + ts.Milliseconds + " Ticks: " + ts.Ticks + " for String of size " + echo.Length);
				total = total + differenceInMillis;
			}
			Console.WriteLine();
			Console.WriteLine("Total Duration: " + total + " ms");
			Console.WriteLine("Average Duration: " + total / 10 + " ms per 100 msgs");
			Console.ReadLine();
		}
	}
}
