using System;

using Microsoft.Web.Services2;
using Microsoft.Web.Services2.Security;
using Microsoft.Web.Services2.Security.Tokens;
using Microsoft.Web.Services2.Security.X509;

using WSSCClient.WSSCService;

namespace WSSCClient
{
	public class SCTClient
	{
		private static String data = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";

		[STAThread]
		static void Main(string[] args)
		{
			// create a new instance of the proxy class for the security token service.
			SecurityContextTokenServiceClient wstClient = new
				SecurityContextTokenServiceClient(new 
				Uri( "http://localhost/WSSCService/SCTService.asmx"));

			// open certificate store
			X509CertificateStore store = 
				X509CertificateStore.LocalMachineStore(
				X509CertificateStore.MyStore);
			bool open = store.OpenRead();

			// get client signature certificate for RST
			X509CertificateCollection certs =
					store.FindCertificateBySubjectString("Signature");
			X509SecurityToken sctSigningToken = new X509SecurityToken((X509Certificate) certs[0]);

			// get service encryption certificate for RST
			certs = store.FindCertificateBySubjectString("Encryption");
			X509SecurityToken serverToken = new X509SecurityToken((X509Certificate) certs[0]);

			// send a signed security context token request
			SecurityContextToken sct = wstClient.IssueSecurityContextTokenAuthenticated(sctSigningToken, serverToken);					
	
			double total = 0;
			String echo = data;

			for (int j=0; j<10; j++)
			{				
				DateTime start = DateTime.Now;
				// call WSSCService operation 
				for (int i=0; i<100; i++)
				{
					// get the request context for the actual request
					SCTServiceWse wsscProxy = new SCTServiceWse();
					SoapContext requestContext = wsscProxy.RequestSoapContext;

					// create derived key token for the SCT
					DerivedKeyToken dkt = new DerivedKeyToken(sct as IDerivableToken);

					// use dkt for request security
					requestContext.Security.Tokens.Add(dkt);
					requestContext.Security.Elements.Add(new MessageSignature(dkt));
					requestContext.Security.Elements.Add(new EncryptedData(dkt));

					String result = wsscProxy.SecureEcho(echo);
				}
				DateTime end = DateTime.Now;							
				TimeSpan ts = end - start;
				
				double differenceInMillis = ts.TotalMilliseconds;
				
				Console.WriteLine("Duration: " + ts.Hours + ":" + ts.Minutes + ":" + ts.Seconds + ":" + ts.Milliseconds + " Ticks: " + ts.Ticks + " for String of size " + echo.Length);
				total = total + differenceInMillis;
			}
			Console.WriteLine();
			Console.WriteLine("Total Duration: " + total + " ms");
			Console.WriteLine("Average Duration: " + total / 10 + " ms per 100 msgs");
			Console.ReadLine();
		}
	}
}