using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Web;
using System.Web.Services;


using Microsoft.Web.Services2;
using Microsoft.Web.Services2.Security;
using Microsoft.Web.Services2.Security.Tokens;

namespace WSSService
{
	/// <summary>
	/// Summary description for Service1.
	/// </summary>
	public class SecureService : System.Web.Services.WebService
	{
		public SecureService()
		{		
			InitializeComponent();
		}

		#region Component Designer generated code
		
		//Required by the Web Services Designer 
		private IContainer components = null;
				
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(disposing && components != null)
			{
				components.Dispose();
			}
			base.Dispose(disposing);		
		}
		
		#endregion

		[WebMethod]
		public string SecureEcho(String input)
		{
			SoapContext requestContext = RequestSoapContext.Current;
				
			// make sure only X.509 tokens are used
			int numX509 = 0;		
			foreach (SecurityToken token in requestContext.Security.Tokens)
			{
				if (token is X509SecurityToken)
					numX509++;
			}
			if (numX509 != 1)
			{
				throw new SecurityFault(SecurityFault.InvalidSecurityTokenMessage, SecurityFault.InvalidSecurityTokenCode);
			}

			// check if SOAP message is signed and encrypted by the two X.509 Token
			X509SecurityToken signatureToken = null;
			X509SecurityToken encryptionToken = null;

			foreach ( ISecurityElement element in requestContext.Security.Elements )
			{
				if ( element is MessageSignature )
				{
					// the given context contains a Signature element.
					MessageSignature sig = element as MessageSignature;
                   
					// the SOAP Body is signed.
					signatureToken = (X509SecurityToken)sig.SigningToken;
				}

				if ( element is EncryptedData )
				{
					EncryptedData encryptedData = element as EncryptedData;
					System.Xml.XmlElement targetElement = encryptedData.TargetElement;										
							
					if ( SoapEnvelope.IsSoapBody(targetElement))
					{
						// The given context has the Body element Encrypted.
						encryptionToken = (X509SecurityToken)encryptedData.SecurityToken;
					}
				}
			}

			if (signatureToken == null || encryptionToken == null)
			{
				throw new SecurityFault(SecurityFault.InvalidSecurityMessage, SecurityFault.InvalidSecurityCode);
			}
			
			// Use the tokens vice versa for the response
			SoapContext responseContext = ResponseSoapContext.Current;

			responseContext.Security.Tokens.Add(encryptionToken);
			responseContext.Security.Elements.Add(new MessageSignature(encryptionToken));
			responseContext.Security.Elements.Add(new EncryptedData(signatureToken));

			return "Received: " + input;
		}
	}
}
