/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.speyside.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.renderkit.BoxRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends BoxRendererBase
implements AjaxRenderer {
    private static final Log LOG = LogFactory.getLog(BoxRenderer.class);

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        return super.getFixedHeight(facesContext, component);
    }

    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
        HtmlRendererUtil.prepareInnerStyle((UIComponent)component);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        String style = (String)component.getAttributes().get("style");
        try {
            String heightString = HtmlRendererUtil.getStyleAttributeValue((String)style, (String)"height").replaceAll("\\D", "");
            int height = Integer.parseInt(heightString) - 1;
            style = HtmlRendererUtil.replaceStyleAttribute((String)style, (String)"height", (String)(height + "px"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String clientId = component.getClientId(facesContext);
        writer.startElement("div", component);
        writer.writeComponentClass();
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("style", (Object)style, null);
        HtmlRendererUtil.writeJavascript((ResponseWriter)writer, (String)("Tobago.addAjaxComponent(\"" + clientId + "\")"));
        this.encodeBeginInner(facesContext, writer, component);
    }

    private void encodeBeginInner(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component) throws IOException {
        this.renderBoxHeader(facesContext, writer, component);
        writer.startElement("div", component);
        writer.writeClassAttribute("tobago-box-content");
        writer.startElement("div", component);
        writer.writeClassAttribute("tobago-box-content-inner");
        writer.writeAttribute("style", null, "style_inner");
    }

    protected void renderBoxHeader(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component) throws IOException {
        writer.startElement("div", component);
        writer.writeClassAttribute("tobago-box-header");
        UIComponent label = component.getFacet("label");
        writer.startElement("span", null);
        writer.writeClassAttribute("tobago-box-header-label");
        String labelString = (String)component.getAttributes().get("label");
        if (label != null) {
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)label);
        } else if (labelString != null) {
            writer.writeText((Object)labelString, null);
        }
        writer.endElement("span");
        UIPanel toolbar = (UIPanel)component.getFacet("toolBar");
        if (toolbar != null) {
            this.renderToolbar(facesContext, writer, toolbar);
        }
        writer.endElement("div");
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        this.encodeEndInner(writer);
        writer.endElement("div");
    }

    private void encodeEndInner(ResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void renderToolbar(FacesContext facesContext, TobagoResponseWriter writer, UIPanel toolbar) throws IOException {
        Map attributes = toolbar.getAttributes();
        String className = "tobago-box-header-toolbar-div";
        if ("off".equals(attributes.get("labelPosition"))) {
            className = className + " tobago-box-header-toolbar-label_off";
        }
        writer.startElement("div", null);
        writer.writeClassAttribute(className);
        attributes.put("suppressToolbarContainer", Boolean.TRUE);
        if ("bottom".equals(attributes.get("labelPosition"))) {
            attributes.put("labelPosition", "right");
        }
        if ("big".equals(attributes.get("iconSize"))) {
            attributes.put("iconSize", "small");
        }
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)toolbar);
        writer.endElement("div");
    }

    public void encodeAjax(FacesContext facesContext, UIComponent component) throws IOException {
        AjaxUtils.checkParamValidity((FacesContext)facesContext, (UIComponent)component, UIPanel.class);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        this.encodeBeginInner(facesContext, writer, component);
        component.encodeChildren(facesContext);
        this.encodeEndInner((ResponseWriter)writer);
        facesContext.responseComplete();
    }
}

