/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.renderkit.BoxRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends BoxRendererBase {
    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
        HtmlRendererUtil.prepareInnerStyle((UIComponent)component);
        UIComponent label = component.getFacet("label");
        String labelString = (String)component.getAttributes().get("label");
        String style = (String)component.getAttributes().get(this.getAttrStyleKey());
        UIPanel toolbar = (UIPanel)component.getFacet("toolBar");
        if (toolbar != null) {
            int padding = this.getConfiguredValue(facesContext, component, "paddingTopWhenToolbar");
            style = HtmlRendererUtil.replaceStyleAttribute((String)style, (String)"padding-top", (String)(Integer.toString(padding) + "px"));
            style = HtmlRendererUtil.replaceStyleAttribute((String)style, (String)"padding-bottom", (String)"0px");
        }
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("fieldset", component);
        writer.writeComponentClass();
        writer.writeAttribute("style", (Object)style, null);
        if (label != null || labelString != null) {
            writer.startElement("legend", component);
            writer.writeComponentClass();
            writer.writeText((Object)"", null);
            if (label != null) {
                RenderUtil.encode((FacesContext)facesContext, (UIComponent)label);
            } else {
                writer.writeText((Object)labelString, null);
            }
            writer.endElement("legend");
        }
        String contentStyle = (String)component.getAttributes().get("style_inner");
        if (toolbar != null) {
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-box-toolbar-div");
            writer.startElement("div", null);
            writer.writeClassAttribute("tobago-box-toolbar-span");
            Map attributes = toolbar.getAttributes();
            attributes.put("suppressToolbarContainer", Boolean.TRUE);
            if ("bottom".equals(attributes.get("labelPosition"))) {
                attributes.put("labelPosition", "right");
            }
            if ("big".equals(attributes.get("iconSize"))) {
                attributes.put("iconSize", "small");
            }
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)toolbar);
            writer.endElement("div");
            writer.endElement("div");
            if (ClientProperties.getInstance((UIViewRoot)facesContext.getViewRoot()).getUserAgent().isMsie()) {
                contentStyle = HtmlRendererUtil.replaceStyleAttribute((String)contentStyle, (String)"top", (String)"-10px");
            }
        }
        writer.startElement("div", component);
        writer.writeComponentClass();
        writer.writeAttribute("style", (Object)contentStyle, null);
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
        writer.endElement("fieldset");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getAttrStyleKey() {
        return "style";
    }

    public int getPaddingHeight(FacesContext facesContext, UIComponent component) {
        int paddingHeight = super.getPaddingHeight(facesContext, component);
        int extraPadding = 0;
        if (component.getFacet("toolBar") != null) {
            extraPadding = this.getExtraPadding(facesContext, component);
        }
        return paddingHeight + extraPadding;
    }

    private int getExtraPadding(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "extraPaddingHeightWhenToolbar");
    }
}

