/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ButtonRenderer
extends CommandRendererBase {
    private static final Log LOG = LogFactory.getLog(ButtonRenderer.class);

    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
        String onclick;
        String clientId = component.getClientId(facesContext);
        String buttonType = this.createButtonType(component);
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled");
        if (disabled) {
            onclick = "";
        } else {
            onclick = ButtonRenderer.createOnClick(facesContext, component);
            onclick = CommandRendererBase.appendConfirmationScript((String)onclick, (UIComponent)component, (FacesContext)facesContext);
        }
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        LabelWithAccessKey label = new LabelWithAccessKey(component);
        writer.startElement("button", component);
        writer.writeAttribute("type", (Object)buttonType, null);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("title", null, "tip");
        writer.writeAttribute("disabled", disabled);
        if (onclick != null) {
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        writer.writeAttribute("style", null, "style");
        writer.writeComponentClass();
        writer.writeText((Object)"", null);
        String imageName = (String)component.getAttributes().get("image");
        if (imageName != null) {
            String image = null;
            if (disabled) {
                image = ResourceManagerUtil.getDisabledImageWithPath((FacesContext)facesContext, (String)imageName);
            }
            if (image == null) {
                image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)imageName);
            }
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)image, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.endElement("img");
        }
        if (label.getText() != null) {
            if (imageName != null) {
                writer.writeText((Object)" ", null);
            }
            HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
        }
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
            }
            HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)clientId, (char)label.getAccessKey().charValue());
        }
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("button");
    }

    private String createButtonType(UIComponent component) {
        boolean defaultCommand = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"defaultCommand");
        String buttonType = defaultCommand ? "submit" : "button";
        return buttonType;
    }

    public static String createOnClick(FacesContext facesContext, UIComponent component) {
        String onclick;
        String clientId = component.getClientId(facesContext);
        boolean defaultCommand = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"defaultCommand");
        if (component.getAttributes().get("link") != null) {
            onclick = "Tobago.navigateToUrl('" + HtmlUtils.generateUrl((FacesContext)facesContext, (String)((String)component.getAttributes().get("link"))) + "');";
        } else if (component.getAttributes().get("onclick") != null) {
            onclick = (String)component.getAttributes().get("onclick");
        } else if (defaultCommand) {
            ComponentUtil.findPage((UIComponent)component).setDefaultActionId(clientId);
            onclick = null;
        } else {
            onclick = "Tobago.submitAction('" + clientId + "');";
        }
        return onclick;
    }
}

