/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.model.CalendarModel;
import org.apache.myfaces.tobago.model.DateModel;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class CalendarRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(CalendarRenderer.class);

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        Calendar calendar;
        UIOutput output = (UIOutput)component;
        UIPage page = ComponentUtil.findPage((UIComponent)output);
        page.getScriptFiles().add("script/calendar.js");
        page.getScriptFiles().add("script/dateConverter.js");
        String id = output.getClientId(facesContext);
        String dateTextBoxId = (String)component.getAttributes().get("CalendarDateInputId");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("dateTextBoxId = '" + dateTextBoxId + "'"));
        }
        Locale locale = facesContext.getViewRoot().getLocale();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM yyyy", locale);
        Object value = output.getValue();
        if (value instanceof Calendar) {
            calendar = (Calendar)value;
        } else {
            calendar = new GregorianCalendar();
            if (value instanceof Date) {
                calendar.setTime((Date)value);
            }
        }
        CalendarModel model = new CalendarModel(calendar);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("table", component);
        writer.writeIdAttribute(id);
        writer.writeComponentClass();
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"3", null);
        writer.writeAttribute("summary", (Object)"", null);
        writer.startElement("tr", null);
        writer.writeClassAttribute("tobago-calendar-header-tr");
        writer.startElement("th", null);
        writer.writeAttribute("colspan", (Object)"7", null);
        writer.startElement("table", null);
        writer.writeAttribute("summary", (Object)"", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)"left", null);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("src", (Object)ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarFastPrev.gif"), null);
        writer.writeAttribute("onclick", (Object)("addMonth('" + id + "', -12)"), null);
        writer.endElement("img");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)"left", null);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("src", (Object)ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarPrev.gif"), null);
        writer.writeAttribute("onclick", (Object)("addMonth('" + id + "', -1)"), null);
        writer.endElement("img");
        writer.endElement("td");
        writer.startElement("th", null);
        writer.writeClassAttribute("tobago-calendar-header-center");
        writer.writeAttribute("align", (Object)"center", null);
        writer.writeIdAttribute(id + ":title");
        writer.writeText((Object)dateFormat.format(calendar.getTime()), null);
        writer.endElement("th");
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)"right", null);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("src", (Object)ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarNext.gif"), null);
        writer.writeAttribute("onclick", (Object)("addMonth('" + id + "', 1)"), null);
        writer.endElement("img");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)"right", null);
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-calendar-header");
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("src", (Object)ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/calendarFastNext.gif"), null);
        writer.writeAttribute("onclick", (Object)("addMonth('" + id + "', 12)"), null);
        writer.endElement("img");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("th");
        writer.endElement("tr");
        writer.startElement("tr", null);
        dateFormat = new SimpleDateFormat("E", locale);
        for (int dayIt = 0; dayIt < 7; ++dayIt) {
            DateModel date = model.getDate(0, dayIt);
            String dayName = dateFormat.format(date.getCalendar().getTime());
            dayName = StringUtils.substring((String)dayName, (int)0, (int)2);
            writer.startElement("th", null);
            writer.writeClassAttribute("tobago-calendar-inner-header");
            writer.writeText((Object)dayName, null);
            writer.endElement("th");
        }
        writer.endElement("tr");
        for (int week = 0; week < 6; ++week) {
            writer.startElement("tr", null);
            writer.writeIdAttribute(id + ":" + week);
            for (int dayIt = 0; dayIt < 7; ++dayIt) {
                DateModel date = model.getDate(week, dayIt);
                String dayDescription = String.valueOf(date.getDay());
                String onclick = "selectDay('" + id + "', " + week + " , " + dayIt + ");";
                writer.startElement("td", null);
                writer.writeAttribute("onclick", (Object)onclick, null);
                writer.writeIdAttribute(id + ":" + week + ":" + dayIt);
                writer.writeClassAttribute(CalendarRenderer.getClass(date, model));
                writer.writeText((Object)dayDescription, null);
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("table");
        this.writeInputHidden(writer, "/" + id + "/year", id + ":year", Integer.toString(calendar.get(1)));
        this.writeInputHidden(writer, "/" + id + "/month", id + ":month", Integer.toString(1 + calendar.get(2)));
        this.writeInputHidden(writer, "/" + id + "/day", id + ":day", Integer.toString(calendar.get(5)));
        this.writeInputHidden(writer, id + ":firstDayOfWeek", Integer.toString(calendar.getFirstDayOfWeek()));
        this.writeInputHidden(writer, id + ":monthNames", CalendarRenderer.getMonthNames(locale));
        this.writeInputHidden(writer, id + ":fieldId", "");
        HtmlRendererUtil.startJavascript((ResponseWriter)writer);
        writer.writeText((Object)"document.calendar = new Object();", null);
        if (dateTextBoxId != null) {
            writer.writeText((Object)("initCalendarParse('" + id + "', '" + dateTextBoxId + "');"), null);
        }
        HtmlRendererUtil.endJavascript((ResponseWriter)writer);
    }

    private void writeInputHidden(TobagoResponseWriter writer, String id, Object value) throws IOException {
        this.writeInputHidden(writer, null, id, value);
    }

    private void writeInputHidden(TobagoResponseWriter writer, String name, String id, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        if (name != null) {
            writer.writeNameAttribute(name);
        }
        writer.writeIdAttribute(id);
        writer.writeAttribute("value", value, null);
        writer.endElement("input");
    }

    private static String getClass(DateModel date, CalendarModel model) {
        return date.getMonth() == model.getMonth() ? "tobago-calendar-day" : "tobago-calendar-day-disabled";
    }

    private static String getMonthNames(Locale locale) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMMM", locale);
        StringBuffer buffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1);
        for (int month = 0; month < 12; ++month) {
            if (month > 0) {
                buffer.append(',');
            }
            buffer.append(dateFormat.format(calendar.getTime()));
            calendar.add(2, 1);
        }
        return buffer.toString();
    }
}

