/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.config.ThemeConfig;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.event.DatePickerController;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.InRenderer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class DateRenderer
extends InRenderer {
    private static final Log LOG = LogFactory.getLog(DateRenderer.class);

    protected void renderMain(FacesContext facesContext, UIInput input, TobagoResponseWriter writer) throws IOException {
        String[] scripts = new String[]{"script/date.js", "script/dateConverter.js", "script/calendar.js"};
        List scriptFiles = ComponentUtil.findPage((UIComponent)input).getScriptFiles();
        for (String script : scripts) {
            scriptFiles.add(script);
        }
        if (TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, null);
        }
        String classes = ComponentUtil.getStringAttribute((UIComponent)input, (String)"styleClass");
        classes = classes.replaceAll("tobago-date-", "tobago-in-");
        input.getAttributes().put("styleClass", classes);
        super.renderMain(facesContext, input, writer);
        UIComponent picker = input.getFacet("picker");
        if (picker == null) {
            picker = this.createPicker((UIComponent)input);
            input.getFacets().put("picker", picker);
        }
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)picker);
        UIPopup popup = (UIPopup)picker.getFacet("pickerPopup");
        if (popup != null) {
            UIPage page = ComponentUtil.findPage((UIComponent)input);
            page.getPopups().add(popup);
        }
    }

    private UIComponent createPicker(UIComponent component) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String idPrefix = ComponentUtil.createPickerId((FacesContext)facesContext, (UIComponent)component, (String)"");
        DatePickerController datePickerController = new DatePickerController();
        String converterPattern = "yyyy-MM-dd";
        Converter converter = ((UIOutput)component).getConverter();
        if (converter instanceof DateTimeConverter) {
            converterPattern = ((DateTimeConverter)converter).getPattern();
        }
        UICommand link = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"javax.faces.Command", (String)"Link");
        link.setImmediate(true);
        link.setRendered(true);
        link.setImmediate(true);
        Map attributes = link.getAttributes();
        link.setId(idPrefix + "openPopup");
        link.setActionListener((MethodBinding)datePickerController);
        attributes.put("layoutWidth", this.getConfiguredValue(facesContext, component, "pickerWidth"));
        org.apache.myfaces.tobago.component.UIInput hidden = (org.apache.myfaces.tobago.component.UIInput)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Input", (String)"Hidden");
        link.getChildren().add(hidden);
        hidden.setId(idPrefix + "Dimension");
        attributes.put("onclick", "Tobago.openPickerPopup(event, '" + link.getClientId(facesContext) + "', '" + hidden.getClientId(facesContext) + "')");
        UIComponent popup = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Popup", (String)"Popup");
        link.getFacets().put("pickerPopup", popup);
        popup.setRendered(false);
        popup.setId(idPrefix + "popup");
        attributes = popup.getAttributes();
        attributes.put("popupReset", Boolean.TRUE);
        attributes.put("width", String.valueOf(ThemeConfig.getValue((FacesContext)facesContext, (UIComponent)component, (String)"CalendarPopupWidth")));
        attributes.put("height", String.valueOf(ThemeConfig.getValue((FacesContext)facesContext, (UIComponent)component, (String)"CalendarPopupHeight")));
        UIComponent box = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Box");
        popup.getChildren().add(box);
        box.setId("box");
        box.getAttributes().put("label", "datePicker");
        UIComponent layout = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.GridLayout", (String)"GridLayout");
        box.getFacets().put("layout", layout);
        layout.setId("layout");
        layout.getAttributes().put("rows", "1*;fixed;fixed;fixed");
        UIComponent calendar = ComponentUtil.createComponent((FacesContext)facesContext, (String)"javax.faces.Output", (String)"Calendar");
        box.getChildren().add(calendar);
        calendar.setId("calendar");
        calendar.getAttributes().put("CalendarDateInputId", component.getClientId(facesContext));
        if (converterPattern.indexOf(104) > -1 || converterPattern.indexOf(72) > -1) {
            UIComponent timePanel = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Panel");
            timePanel.setId("timePanel");
            box.getChildren().add(timePanel);
            layout = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.GridLayout", (String)"GridLayout");
            timePanel.getFacets().put("layout", layout);
            layout.setId("timePanelLayout");
            layout.getAttributes().put("columns", "1*;fixed;1*");
            UIComponent cell = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Panel");
            cell.setId("cell1");
            timePanel.getChildren().add(cell);
            UIComponent time = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Input", (String)"Time");
            timePanel.getChildren().add(time);
            time.setId("time");
            time.getAttributes().put("CalendarDateInputId", component.getClientId(facesContext));
            if (converterPattern.indexOf(115) > -1) {
                time.getAttributes().put("popupCalendarForceTime", true);
            }
            cell = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Panel");
            cell.setId("cell2");
            timePanel.getChildren().add(cell);
        } else {
            UIComponent cell = ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Panel");
            cell.setId("emptyCell");
            box.getChildren().add(cell);
        }
        UICommand okButton = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", (String)"Button");
        box.getChildren().add(okButton);
        okButton.setId("okclosePopup");
        attributes = okButton.getAttributes();
        attributes.put("label", "OK");
        attributes.put("onclick", "writeIntoField('" + popup.getClientId(facesContext) + "', '" + component.getClientId(facesContext) + "'); Tobago.closePickerPopup('" + popup.getClientId(facesContext) + "')");
        okButton.setActionListener((MethodBinding)datePickerController);
        UICommand cancelButton = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", (String)"Button");
        box.getChildren().add(cancelButton);
        attributes = cancelButton.getAttributes();
        attributes.put("label", "Cancel");
        attributes.put("onclick", "Tobago.closePickerPopup('" + popup.getClientId(facesContext) + "')");
        cancelButton.setId("closePopup");
        cancelButton.setActionListener((MethodBinding)datePickerController);
        UIGraphic image = (UIGraphic)ComponentUtil.createComponent((FacesContext)facesContext, (String)"javax.faces.Graphic", (String)"Image");
        image.setRendered(true);
        image.setValue((Object)"image/date.gif");
        image.getAttributes().put("alt", "");
        image.getAttributes().put("styleClass", "tobago-input-picker");
        image.setId(idPrefix + "image");
        link.getChildren().add(image);
        return link;
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "pickerWidth");
    }
}

