/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoMultipartFormdataRequest;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class FileRenderer
extends InputRendererBase {
    private static final Log LOG = LogFactory.getLog(FileRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        int space = 0;
        if (component.getFacet("label") != null) {
            int labelWidht = LayoutUtil.getLabelWidth((UIComponent)component);
            space += labelWidht != 0 ? labelWidht : this.getLabelWidth(facesContext, component);
        }
        return space;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        ServletRequest wrappedRequest;
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UIInput input = (UIInput)component;
        TobagoMultipartFormdataRequest request = null;
        Object requestObject = facesContext.getExternalContext().getRequest();
        if (requestObject instanceof TobagoMultipartFormdataRequest) {
            request = (TobagoMultipartFormdataRequest)requestObject;
        } else if (requestObject instanceof HttpServletRequestWrapper && (wrappedRequest = ((HttpServletRequestWrapper)requestObject).getRequest()) instanceof TobagoMultipartFormdataRequest) {
            request = (TobagoMultipartFormdataRequest)wrappedRequest;
        }
        if (request == null) {
            LOG.error((Object)"Can't process multipart/form-data without TobagoRequest. Please check the web.xml and define a TobagoMultipartFormdataFilter. See documentation for <tc:file>");
        }
        FileItem item = request.getFileItem(input.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Uploaded file name : \"" + item.getName() + "\"  size = " + item.getSize()));
        }
        input.setSubmittedValue((Object)item);
        input.setValid(true);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue;
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIInput component = (UIInput)uiComponent;
        String clientId = component.getClientId(facesContext);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)component);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeComponentClass();
        if (!ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMozilla()) {
            writer.writeAttribute("style", null, "style");
        }
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("readonly", ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled"));
        writer.writeAttribute("title", null, "tip");
        writer.endElement("input");
    }
}

