/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.component.UIGridLayout;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.DefaultLayoutRenderer;
import org.apache.myfaces.tobago.util.LayoutInfo;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayoutRenderer
extends DefaultLayoutRenderer {
    private static final Log LOG = LogFactory.getLog(GridLayoutRenderer.class);

    public Dimension getFixedSize(FacesContext facesContext, UIComponent component) {
        Dimension dimension = null;
        int height = this.getFixedHeight(facesContext, component);
        int width = -1;
        dimension = new Dimension(width, height);
        return dimension;
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int height = this.calculateLayoutHeight(facesContext, component, false);
        RendererBase containerRenderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
        height += containerRenderer.getHeaderHeight(facesContext, component);
        return height += containerRenderer.getPaddingHeight(facesContext, component);
    }

    public int calculateLayoutHeight(FacesContext facesContext, UIComponent component, boolean minimum) {
        UIGridLayout layout = (UIGridLayout)UILayout.getLayout((UIComponent)component);
        List rows = layout.ensureRows();
        String rowLayout = (String)layout.getAttributes().get("rows");
        if (rowLayout == null && !minimum && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No rowLayout found using " + (minimum ? "'minimum'" : "'fixed'") + " for all " + rows.size() + " rows of " + layout.getClientId(facesContext) + " !"));
        }
        String[] layoutTokens = LayoutInfo.createLayoutTokens((String)rowLayout, (int)rows.size(), (String)(minimum ? "minimum" : "fixed"));
        if (rows.size() != layoutTokens.length) {
            LOG.warn((Object)("Unbalanced layout: rows.size()=" + rows.size() + " != layoutTokens.length=" + layoutTokens.length + " rowLayout='" + rowLayout + "'"));
        }
        int size = Math.min(rows.size(), layoutTokens.length);
        int height = 0;
        for (int i = 0; i < size && this.rowIsRendered((UIGridLayout.Row)rows.get(i)); ++i) {
            height += this.getCellPadding(facesContext, (UIComponent)layout, i);
            String token = layoutTokens[i];
            if (token.matches("\\d+px")) {
                height += Integer.parseInt(token.replaceAll("\\D", ""));
                continue;
            }
            if (token.equals("fixed")) {
                height += this.getMaxHeight(facesContext, (UIGridLayout.Row)rows.get(i), false);
                continue;
            }
            if (token.equals("minimum")) {
                height += this.getMaxHeight(facesContext, (UIGridLayout.Row)rows.get(i), true);
                continue;
            }
            if (!minimum && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Unable to calculate Height for token '" + token + "'! using " + (minimum ? "'minimum'" : "'fixed'") + " , component:" + layout.getClientId(facesContext) + " is " + layout.getRendererType()));
            }
            height += this.getMaxHeight(facesContext, (UIGridLayout.Row)rows.get(i), minimum);
        }
        return height;
    }

    private boolean rowIsRendered(UIGridLayout.Row row) {
        for (Object element : row.getElements()) {
            UIComponent component;
            if (!(element instanceof UIComponent) || !(component = (UIComponent)element).isRendered()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void encodeChildrenOfComponent(FacesContext facesContext, UIComponent component) throws IOException {
        UIGridLayout layout = (UIGridLayout)UILayout.getLayout((UIComponent)component);
        HtmlRendererUtil.prepareRender((FacesContext)facesContext, (UIComponent)layout);
        this.layoutEnd(facesContext, (UIComponent)layout);
        this.layoutMargins(layout);
        Map attributes = layout.getAttributes();
        List columnWidths = (List)attributes.get("widthList");
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("table", (UIComponent)layout);
        writer.writeAttribute("border", null, "border");
        writer.writeComponentClass();
        writer.writeAttribute("style", null, "layoutTableStyle");
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("summary", (Object)"", null);
        if (columnWidths != null) {
            writer.startElement("colgroup", null);
            for (int i = 0; i < columnWidths.size(); ++i) {
                int cellWidth = (Integer)columnWidths.get(i);
                if (cellWidth == -2) continue;
                writer.startElement("col", null);
                writer.writeAttribute("width", (Object)Integer.toString(cellWidth += this.getCellPadding(facesContext, (UIComponent)layout, i)), null);
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        List rows = layout.ensureRows();
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(rowIndex);
            if (row.isHidden()) continue;
            writer.startElement("tr", null);
            List cells = row.getElements();
            for (int columnIndex = 0; columnIndex < cells.size(); ++columnIndex) {
                Object object;
                boolean hide = false;
                if (columnWidths != null) {
                    Integer columWidth = (Integer)columnWidths.get(columnIndex);
                    boolean bl = hide = columWidth == -2;
                }
                if (hide || (object = cells.get(columnIndex)).toString().equals("used")) continue;
                if (object.equals(UIGridLayout.FREE)) {
                    if (!LOG.isWarnEnabled() || layout.isIgnoreFree()) continue;
                    LOG.warn((Object)("There are free blocks in the layout: id='" + layout.getClientId(facesContext) + "'"));
                    continue;
                }
                UIComponent cell = (UIComponent)object;
                int spanX = UIGridLayout.getSpanX((UIComponent)cell);
                int spanY = UIGridLayout.getSpanY((UIComponent)cell);
                String cssClasses = (String)attributes.get("styleClass");
                cssClasses = cssClasses == null ? "" : cssClasses;
                String cellClasses = "";
                if (rowIndex == 0) {
                    cellClasses = cellClasses + " tobago-gridLayout-first-row";
                }
                if (columnIndex == 0) {
                    cellClasses = cellClasses + " tobago-gridLayout-first-column";
                }
                cellClasses = cssClasses + cellClasses;
                int cellWidth = -1;
                if (columnWidths != null) {
                    cellWidth = 0;
                    for (int i = columnIndex; i < columnIndex + spanX && i < columnWidths.size(); ++i) {
                        cellWidth += (Integer)columnWidths.get(i) + this.getCellPadding(facesContext, (UIComponent)layout, i);
                    }
                }
                int cellHeight = -1;
                try {
                    Integer layoutHeight = LayoutUtil.getLayoutHeight((UIComponent)cell);
                    if (layoutHeight != null) {
                        cellHeight = layoutHeight;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int topPadding = this.getCellPadding(facesContext, (UIComponent)layout, rowIndex);
                String cellStyle = (cellWidth != -1 ? "width: " + cellWidth + "px;" : "") + (cellHeight != -1 ? " height: " + (cellHeight + topPadding) + "px;" : "");
                cellStyle = cellStyle + this.getOverflow(cell);
                writer.startElement("td", null);
                writer.writeClassAttribute("tobago-gridLayout-cell-td");
                writer.writeAttribute("style", (Object)cellStyle, null);
                if (spanX > 1) {
                    writer.writeAttribute("colspan", (Object)Integer.toString(spanX), null);
                }
                if (spanY > 1) {
                    writer.writeAttribute("rowspan", (Object)Integer.toString(spanY), null);
                }
                writer.writeText((Object)"", null);
                if (ComponentUtil.getAttribute((UIComponent)layout, (String)"layoutCellspacing") != null) {
                    cellStyle = cellStyle + " padding: " + this.getCellSpacing(facesContext, (UIComponent)layout) + "px;";
                }
                writer.startElement("div", null);
                writer.writeClassAttribute(cellClasses);
                writer.writeAttribute("style", (Object)cellStyle, null);
                RenderUtil.encode((FacesContext)facesContext, (UIComponent)cell);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getParent() instanceof UIPage) {
            LOG.error((Object)"XXXXXXXXXXXXXXXXXXXXXXX  never XXXXXXXXXXXXXXXXXXXXXX", (Throwable)new Exception());
        } else {
            this.encodeChildrenOfComponent(facesContext, component.getParent());
        }
    }

    private String getOverflow(UIComponent cell) {
        String overflow = "";
        String scrollbars = (String)cell.getAttributes().get("scrollbars");
        if (scrollbars != null) {
            if (scrollbars.equals("false")) {
                overflow = " overflow: hidden;";
            } else if (scrollbars.equals("true")) {
                overflow = " overflow: scroll;";
            } else if (scrollbars.equals("auto")) {
                overflow = " overflow: auto;";
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Illegal value for attribute 'scrollbars' : " + scrollbars));
            }
        }
        return overflow;
    }

    private int getCellPadding(FacesContext facesContext, UIComponent component, int i) {
        return i == 0 ? 0 : this.getCellSpacing(facesContext, component);
    }

    private int getBorder(UIComponent component) {
        int border;
        block3: {
            border = 0;
            String borderWidth = (String)component.getAttributes().get("border");
            try {
                if (borderWidth != null) {
                    border = Integer.parseInt(borderWidth);
                }
            }
            catch (NumberFormatException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)"Can't parse border, using 0!");
            }
        }
        return border;
    }

    private int getSpacingSum(UIComponent component, FacesContext facesContext, int count) {
        int space = 0;
        int border = this.getBorder(component);
        int cellSpacing = this.getCellSpacing(facesContext, component);
        if (border != 0) {
            space = border * 2 + count * 2;
        }
        space += (count - 1) * cellSpacing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("extra count =" + count + ",  space = " + space));
        }
        return space;
    }

    private int getWidthSpacingSum(UIGridLayout component, FacesContext facesContext) {
        int spacingSum = this.getSpacingSum((UIComponent)component, facesContext, component.getColumnCount());
        return spacingSum += this.getComponentExtraWidth(facesContext, (UIComponent)component);
    }

    private int getCellSpacing(FacesContext facesContext, UIComponent component) {
        block3: {
            String cellspacing = (String)component.getAttributes().get("layoutCellspacing");
            if (cellspacing instanceof String) {
                try {
                    return Integer.parseInt(cellspacing);
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Illegal value for cellspacing : " + cellspacing + " using default"));
                }
            }
        }
        return this.getConfiguredValue(facesContext, component, "cellSpacing");
    }

    private void layoutEnd(FacesContext facesContext, UIComponent component) {
        Integer innerWidth;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"doLayout end");
        }
        UIGridLayout layout = (UIGridLayout)component;
        Map attributes = layout.getParent().getAttributes();
        boolean needVerticalScroolbar = false;
        Integer innerHeight = (Integer)attributes.get("innerHeight");
        if (innerHeight != null && innerHeight > 0) {
            int value = innerHeight;
            int minimum = this.calculateLayoutHeight(facesContext, layout.getParent(), true);
            if (minimum > value) {
                value = minimum;
                needVerticalScroolbar = true;
            }
            this.layoutHeight(new Integer(value -= this.getHeightSpacingSum(layout, facesContext)), layout, facesContext);
        }
        if ((innerWidth = (Integer)attributes.get("innerWidth")) != null && innerWidth != -1) {
            int value = innerWidth - this.getWidthSpacingSum(layout, facesContext);
            if (needVerticalScroolbar) {
                String style = (String)layout.getAttributes().get("style");
                style = HtmlRendererUtil.replaceStyleAttribute((String)style, (String)"width", (String)(Integer.toString(value -= this.getConfiguredValue(facesContext, component, "scrollbarWidth")) + "px"));
                layout.getAttributes().put("style", style);
            }
            this.layoutWidth(new Integer(value), layout, facesContext);
        }
    }

    private int getHeightSpacingSum(UIGridLayout layout, FacesContext facesContext) {
        int spacingSum = this.getSpacingSum((UIComponent)layout, facesContext, layout.ensureRows().size());
        return spacingSum += this.getComponentExtraHeight(facesContext, (UIComponent)layout);
    }

    private void layoutWidth(Integer innerWidth, UIGridLayout layout, FacesContext facesContext) {
        List rows = layout.ensureRows();
        int columnCount = layout.getColumnCount();
        String[] layoutTokens = LayoutInfo.createLayoutTokens((String)((String)layout.getAttributes().get("columns")), (int)columnCount);
        if (!rows.isEmpty()) {
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(0);
            List cells = row.getElements();
            for (int i = 0; i < cells.size(); ++i) {
                Object cell = cells.get(i);
                boolean hidden = false;
                if (this.isHidden(cell)) {
                    hidden = true;
                    for (int j = 1; j < rows.size(); ++j) {
                        hidden &= this.isHidden(((UIGridLayout.Row)rows.get(j)).getElements().get(i));
                    }
                }
                if (!hidden) continue;
                layoutTokens[i] = "hide";
            }
        }
        LayoutInfo layoutInfo = new LayoutInfo(columnCount, innerWidth.intValue(), layoutTokens, layout.isIgnoreFree());
        this.parseFixedWidth(layoutInfo, layout, facesContext);
        layoutInfo.parseColumnLayout(innerWidth.doubleValue(), this.getCellSpacing(facesContext, (UIComponent)layout));
        this.setColumnWidths(layout, layoutInfo, facesContext);
        layout.getAttributes().put("widthList", layoutInfo.getSpaceList());
    }

    private boolean isHidden(Object cell) {
        return cell instanceof UIComponent && !((UIComponent)cell).isRendered() || cell instanceof UIGridLayout.Marker && !((UIGridLayout.Marker)cell).isRendered();
    }

    private void layoutHeight(Integer innerHeight, UIGridLayout layout, FacesContext facesContext) {
        List rows = layout.ensureRows();
        String[] layoutTokens = LayoutInfo.createLayoutTokens((String)((String)layout.getAttributes().get("rows")), (int)rows.size(), (String)(rows.size() == 1 ? "1*" : "fixed"));
        for (int i = 0; i < rows.size(); ++i) {
            boolean hidden = true;
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(i);
            List cells = row.getElements();
            for (int j = 0; j < cells.size(); ++j) {
                hidden &= this.isHidden(cells.get(j));
            }
            row.setHidden(hidden);
            if (!hidden) continue;
            layoutTokens[i] = "hide";
        }
        LayoutInfo layoutInfo = new LayoutInfo(rows.size(), innerHeight.intValue(), layoutTokens, layout.isIgnoreFree());
        if (layoutInfo.hasLayoutTokens()) {
            this.parseFixedHeight(layoutInfo, layout, facesContext);
            layoutInfo.parseColumnLayout(innerHeight.doubleValue(), this.getCellSpacing(facesContext, (UIComponent)layout));
        }
        this.setColumnHeights(layout, layoutInfo, facesContext);
    }

    private void parseFixedWidth(LayoutInfo layoutInfo, UIGridLayout layout, FacesContext facesContext) {
        this.parseFixedSpace(layoutInfo, layout, true, facesContext);
    }

    private void parseFixedHeight(LayoutInfo layoutInfo, UIGridLayout layout, FacesContext facesContext) {
        this.parseFixedSpace(layoutInfo, layout, false, facesContext);
    }

    private void parseFixedSpace(LayoutInfo layoutInfo, UIGridLayout layout, boolean width, FacesContext facesContext) {
        String[] tokens = layoutInfo.getLayoutTokens();
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].equals("fixed")) continue;
            int max = 0;
            List rows = layout.ensureRows();
            if (!rows.isEmpty()) {
                if (width) {
                    max = this.getMaxWidth(facesContext, rows, i, false);
                } else if (i < rows.size()) {
                    UIGridLayout.Row row = (UIGridLayout.Row)rows.get(i);
                    max = this.getMaxHeight(facesContext, row, false);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("More LayoutTokens found than rows! skipping! tokens = " + LayoutInfo.tokensToString((String[])tokens) + "  components = " + rows.size()));
                    }
                }
                layoutInfo.update(max, i);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("set column " + i + " from fixed to with " + max));
        }
    }

    private int getMaxHeight(FacesContext facesContext, UIGridLayout.Row row, boolean minimum) {
        int maxHeight = 0;
        List cells = row.getElements();
        for (int j = 0; j < cells.size(); ++j) {
            Object object = cells.get(j);
            if (!(object instanceof UIComponent)) continue;
            UIComponent component = (UIComponent)object;
            int height = -1;
            if (minimum) {
                height = (int)LayoutUtil.getMinimumSize((FacesContext)facesContext, (UIComponent)component).getHeight();
            } else {
                RendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
                if (renderer instanceof RendererBase) {
                    height = renderer.getFixedHeight(facesContext, component);
                }
            }
            maxHeight = Math.max(maxHeight, height);
        }
        return maxHeight;
    }

    private int getMaxWidth(FacesContext facesContext, List<UIGridLayout.Row> rows, int column, boolean minimum) {
        int maxWidth = 0;
        for (UIGridLayout.Row row : rows) {
            if (column >= row.getElements().size()) continue;
            UIComponent component = (UIComponent)row.getElements().get(column);
            int max = -1;
            if (minimum) {
                max = (int)LayoutUtil.getMinimumSize((FacesContext)facesContext, (UIComponent)component).getWidth();
            } else {
                RendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)component);
                if (renderer instanceof RendererBase) {
                    max = renderer.getFixedWidth(facesContext, component);
                }
            }
            maxWidth = Math.max(maxWidth, max);
        }
        return maxWidth;
    }

    private void setColumnWidths(UIGridLayout layout, LayoutInfo layoutInfo, FacesContext facesContext) {
        List rows = layout.ensureRows();
        for (UIGridLayout.Row row : rows) {
            List cells = row.getElements();
            int columnCount = layout.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                if (!(cells.get(i) instanceof UIComponent)) continue;
                UIComponent cell = (UIComponent)cells.get(i);
                int spanX = UIGridLayout.getSpanX((UIComponent)cell);
                int cellWidth = 0;
                for (int j = i; j < i + spanX; ++j) {
                    cellWidth += layoutInfo.getSpaceForColumn(j);
                }
                if (spanX > 1 && this.getBorder((UIComponent)layout) > 0) {
                    cellWidth += (spanX - 1) * 2;
                }
                LayoutUtil.maybeSetLayoutAttribute((UIComponent)cell, (String)"layoutWidth", (Integer)new Integer(cellWidth += (spanX - 1) * this.getCellSpacing(facesContext, (UIComponent)layout)));
            }
        }
    }

    private void setColumnHeights(UIGridLayout layout, LayoutInfo layoutInfo, FacesContext facesContext) {
        List rows = layout.ensureRows();
        for (int i = 0; i < rows.size(); ++i) {
            UIGridLayout.Row row = (UIGridLayout.Row)rows.get(i);
            List cells = row.getElements();
            int columnCount = layout.getColumnCount();
            for (int j = 0; j < columnCount; ++j) {
                if (!(cells.get(j) instanceof UIComponent)) continue;
                UIComponent cell = (UIComponent)cells.get(j);
                int spanY = UIGridLayout.getSpanY((UIComponent)cell);
                int cellHeight = 0;
                for (int k = i; k < i + spanY; ++k) {
                    cellHeight += layoutInfo.getSpaceForColumn(k);
                }
                if (spanY > 1 && this.getBorder((UIComponent)layout) > 0) {
                    cellHeight += (spanY - 1) * 2;
                }
                cellHeight += (spanY - 1) * this.getCellSpacing(facesContext, (UIComponent)layout);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("set height of " + cellHeight + "px to " + cell.getRendererType()));
                }
                cell.getAttributes().put("layoutHeight", new Integer(cellHeight));
                cell.getAttributes().remove("innerHeight");
                if (!(cell instanceof UICell) && !(cell instanceof UIForm)) continue;
                List children = LayoutUtil.addChildren(new ArrayList(), (UIComponent)cell);
                for (UIComponent component : children) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("set height of " + cellHeight + "px to " + component.getRendererType()));
                    }
                    component.getAttributes().put("layoutHeight", new Integer(cellHeight));
                    component.getAttributes().remove("innerHeight");
                }
            }
        }
    }

    public void layoutBegin(FacesContext facesContext, UIComponent component) {
        LOG.info((Object)"############################## layoutBegin +++++++++++++++++++++++++++++++++++++++++");
        HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)component, (boolean)true);
        HtmlRendererUtil.layoutSpace((FacesContext)facesContext, (UIComponent)component, (boolean)false);
        if (component instanceof UIGridLayout) {
            this.layoutMargins((UIGridLayout)component);
        }
    }

    private void layoutMargins(UIGridLayout layout) {
        String margin = (String)layout.getAttributes().get("margin");
        String marginTop = this.getMargin(layout, "marginTop", margin);
        String marginRight = this.getMargin(layout, "marginRight", margin);
        String marginBottom = this.getMargin(layout, "marginBottom", margin);
        String marginLeft = this.getMargin(layout, "marginLeft", margin);
        String style = (String)layout.getAttributes().get("style");
        if (style != null) {
            style = this.addStyle(style, "margin-top", marginTop);
            style = this.addStyle(style, "margin-right", marginRight);
            style = this.addStyle(style, "margin-bottom", marginBottom);
            style = this.addStyle(style, "margin-left", marginLeft);
            layout.getAttributes().put("layoutTableStyle", style);
        }
    }

    private String addStyle(String style, String attribute, String value) {
        if (value != null) {
            style = style + " " + attribute + ": " + value + ";";
        }
        return style;
    }

    private String getMargin(UIGridLayout layout, String attribute, String defaultMargin) {
        String margin = (String)layout.getAttributes().get(attribute);
        if (margin == null && defaultMargin != null) {
            margin = defaultMargin;
        }
        return margin;
    }

    public int getComponentExtraWidth(FacesContext facesContext, UIComponent component) {
        int extra = 0;
        UIGridLayout layout = (UIGridLayout)component;
        String margin = (String)layout.getAttributes().get("margin");
        extra += this.getMaginAsInt(this.getMargin(layout, "marginRight", margin));
        return extra += this.getMaginAsInt(this.getMargin(layout, "marginLeft", margin));
    }

    public int getComponentExtraHeight(FacesContext facesContext, UIComponent component) {
        int extra = 0;
        UIGridLayout layout = (UIGridLayout)component;
        String margin = (String)layout.getAttributes().get("margin");
        extra += this.getMaginAsInt(this.getMargin(layout, "marginTop", margin));
        return extra += this.getMaginAsInt(this.getMargin(layout, "marginBottom", margin));
    }

    private int getMaginAsInt(String margin) {
        int intValue;
        block3: {
            intValue = 0;
            if (margin != null) {
                try {
                    intValue += Integer.parseInt(margin.replaceAll("\\D", ""));
                }
                catch (NumberFormatException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)("Illegal Margin : " + margin + " exception : " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return intValue;
    }
}

