/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class ImageRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(ImageRenderer.class);

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        String alt;
        String border;
        String ucSrc;
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        UIGraphic graphic = (UIGraphic)component;
        String value = graphic.getUrl();
        String src = value;
        if (!(src == null || (ucSrc = src.toUpperCase()).startsWith("HTTP:") || ucSrc.startsWith("FTP:") || ucSrc.startsWith("/"))) {
            src = null;
            if (this.isDisabled(graphic)) {
                src = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)HtmlRendererUtil.createSrc((String)value, (String)"Disabled"), (boolean)true);
            }
            if (src == null) {
                src = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)value);
            }
            HtmlRendererUtil.addImageSources((FacesContext)facesContext, (ResponseWriter)writer, (String)graphic.getUrl(), (String)graphic.getClientId(facesContext));
        }
        if ((border = (String)graphic.getAttributes().get("border")) == null) {
            border = "0";
        }
        if ((alt = (String)graphic.getAttributes().get("alt")) == null) {
            alt = "";
        }
        String tip = (String)graphic.getAttributes().get("tip");
        writer.startElement("img", (UIComponent)graphic);
        String clientId = graphic.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        if (ComponentUtil.isHoverEnabled((UIComponent)graphic) && !this.isDisabled(graphic)) {
            writer.writeAttribute("onmouseover", (Object)("Tobago.imageMouseover('" + clientId + "')"), null);
            writer.writeAttribute("onmouseout", (Object)("Tobago.imageMouseout('" + clientId + "')"), null);
        }
        if (src != null) {
            writer.writeAttribute("src", (Object)src, null);
        }
        writer.writeAttribute("alt", (Object)alt, null);
        if (tip != null) {
            writer.writeAttribute("title", (Object)tip, null);
        }
        writer.writeAttribute("border", (Object)border, null);
        writer.writeAttribute("height", null, "height");
        writer.writeAttribute("style", null, "style");
        writer.writeComponentClass();
        writer.endElement("img");
    }

    public static String createSrc(String src, String ext) {
        int dot = src.lastIndexOf(46);
        if (dot == -1) {
            LOG.warn((Object)("Image src without extension: '" + src + "'"));
            return src;
        }
        return src.substring(0, dot) + ext + src.substring(dot);
    }

    private boolean isDisabled(UIGraphic graphic) {
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)graphic, (String)"disabled");
        if (!disabled && graphic.getParent() instanceof UICommand) {
            disabled = ComponentUtil.getBooleanAttribute((UIComponent)graphic.getParent(), (String)"disabled");
        }
        return disabled;
    }
}

