/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.ajax.api.AjaxPhaseListener;
import org.apache.myfaces.tobago.ajax.api.AjaxRenderer;
import org.apache.myfaces.tobago.ajax.api.AjaxUtils;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.renderkit.html.InRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class InRenderer
extends InRendererBase
implements AjaxRenderer {
    private static final Log LOG = LogFactory.getLog(InRenderer.class);

    protected void renderMain(FacesContext facesContext, UIInput input, TobagoResponseWriter writer) throws IOException {
        String pattern;
        Converter converter;
        Iterator messages = facesContext.getMessages(input.getClientId(facesContext));
        StringBuffer stringBuffer = new StringBuffer();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            stringBuffer.append(message.getDetail());
        }
        String title = null;
        if (stringBuffer.length() > 0) {
            title = stringBuffer.toString();
        }
        title = HtmlRendererUtil.addTip((String)title, (String)((String)input.getAttributes().get("tip")));
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentValue = '" + currentValue + "'"));
        }
        String type = ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"password") ? "password" : "text";
        boolean renderAjaxSuggest = false;
        if (input instanceof org.apache.myfaces.tobago.component.UIInput) {
            renderAjaxSuggest = ((org.apache.myfaces.tobago.component.UIInput)input).getSuggestMethod() != null;
        }
        String onchange = HtmlUtils.generateOnchange((UIInput)input, (FacesContext)facesContext);
        String id = input.getClientId(facesContext);
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", (Object)type, null);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        if (currentValue != null) {
            writer.writeAttribute("value", (Object)currentValue, null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.writeAttribute("readonly", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"readonly"));
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)input, (String)"disabled"));
        writer.writeAttribute("style", null, "style");
        writer.writeComponentClass();
        if (renderAjaxSuggest) {
            writer.writeAttribute("autocomplete", "off", false);
        }
        if (onchange != null) {
            // empty if block
        }
        writer.endElement("input");
        if (input.getConverter() != null && (converter = input.getConverter()) instanceof DateTimeConverter && (pattern = ((DateTimeConverter)converter).getPattern()) != null) {
            writer.startElement("input", (UIComponent)input);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeIdAttribute(id + ":converterPattern");
            writer.writeAttribute("value", (Object)pattern, null);
            writer.endElement("input");
        }
        if (renderAjaxSuggest) {
            String popupId = id + "::" + "ajaxPopup";
            UIPage page = ComponentUtil.findPage((UIComponent)input);
            page.getScriptFiles().add("script/effects.js");
            page.getScriptFiles().add("script/dragdrop.js");
            page.getScriptFiles().add("script/controls.js");
            page.getScriptFiles().add("script/inputSuggest.js");
            writer.startElement("div");
            writer.writeClassAttribute("tobago-in-suggest-popup");
            writer.writeAttribute("style", (Object)"display: none;", null);
            writer.writeIdAttribute(popupId);
            writer.endElement("div");
            String[] scripts = new String[]{"script/effects.js", "script/dragdrop.js", "script/controls.js", "script/inputSuggest.js"};
            String[] cmds = new String[]{"new Tobago.Autocompleter(", "    '" + id + "',", "    '" + page.getClientId(facesContext) + "',", "    { method:       'post',", "      asynchronous: true,", "      parameters: ''", "    });"};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])scripts, (String[])cmds);
        }
    }

    public void encodeAjax(FacesContext context, UIComponent uiComponent) throws IOException {
        AjaxUtils.checkParamValidity((FacesContext)context, (UIComponent)uiComponent, org.apache.myfaces.tobago.component.UIInput.class);
        org.apache.myfaces.tobago.component.UIInput input = (org.apache.myfaces.tobago.component.UIInput)uiComponent;
        MethodBinding o = input.getSuggestMethod();
        if (!(o instanceof MethodBinding)) {
            return;
        }
        MethodBinding mb = o;
        int maxSuggestedCount = 25;
        List suggesteds = (List)mb.invoke(context, new Object[]{AjaxPhaseListener.getValueForComponent((FacesContext)context, (UIComponent)uiComponent)});
        StringBuffer buf = new StringBuffer();
        buf.append("<ul>");
        Iterator i = suggesteds.iterator();
        for (int suggestedCount = 0; i.hasNext() && suggestedCount <= maxSuggestedCount; ++suggestedCount) {
            buf.append("<li>");
            buf.append(i.next().toString());
            buf.append("</li>");
        }
        buf.append("</ul>");
        context.getResponseWriter().write(buf.toString());
        context.responseComplete();
    }
}

