/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.util.LayoutUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class LabelRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(LabelRenderer.class);

    private void createClassAttribute(UIComponent component) {
        String rendererType = component.getRendererType().toLowerCase();
        String name = this.getRendererName(rendererType);
        UIComponent parent = this.findParent(component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        styleClass = HtmlRendererUtil.updateClassAttribute((String)styleClass, (String)name, (UIComponent)parent);
        component.getAttributes().put("styleClass", styleClass);
    }

    private UIComponent findParent(UIComponent component) {
        UIComponent parent = component.getParent();
        if (component != parent.getFacet("label")) {
            parent = ComponentUtil.findFor((UIComponent)component);
        }
        if (parent == null) {
            parent = component;
        }
        return parent;
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        UIOutput output = (UIOutput)component;
        Integer width = LayoutUtil.getLayoutWidth((UIComponent)output);
        if (width == null && !ComponentUtil.getBooleanAttribute((UIComponent)this.findParent(component), (String)"inline") && !ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"inline")) {
            width = new Integer(this.getConfiguredValue(facesContext, component, "labelWidth"));
        }
        LabelWithAccessKey label = new LabelWithAccessKey(component);
        String forValue = ComponentUtil.findClientIdFor((UIComponent)output, (FacesContext)facesContext);
        this.createClassAttribute(component);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)output);
        writer.writeComponentClass();
        writer.writeAttribute("style", null, "style");
        writer.startElement("a", (UIComponent)output);
        writer.writeComponentClass();
        writer.startElement("label", (UIComponent)output);
        String clientId = output.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        if (forValue != null) {
            writer.writeAttribute("for", (Object)forValue, null);
        }
        writer.writeComponentClass();
        if (width != null) {
            writer.writeAttribute("style", (Object)("width: " + width + "px;"), null);
        }
        writer.writeAttribute("title", null, "tip");
        if (label.getText() != null) {
            HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("label");
        writer.endElement("a");
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
            }
            HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)clientId, (char)label.getAccessKey().charValue());
        }
        writer.endElement("div");
    }
}

