/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class LinkRenderer
extends CommandRendererBase {
    private static final Log LOG = LogFactory.getLog(LinkRenderer.class);

    public void encodeBeginTobago(FacesContext facesContext, UIComponent component) throws IOException {
        String href;
        String onclick = null;
        String clientId = component.getClientId(facesContext);
        if (component.getAttributes().get("link") != null) {
            String action = (String)component.getAttributes().get("link");
            if (action == null) {
                LOG.warn((Object)("keine Action in Link : id " + clientId + " label = " + component.getAttributes().get("label")));
                action = "";
            }
            href = HtmlUtils.generateUrl((FacesContext)facesContext, (String)action);
        } else if (component.getAttributes().get("onclick") != null) {
            onclick = (String)component.getAttributes().get("onclick");
            href = "#";
        } else {
            href = "javascript:Tobago.submitAction('" + clientId + "')";
        }
        onclick = CommandRendererBase.appendConfirmationScript((String)onclick, (UIComponent)component, (FacesContext)facesContext);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        LabelWithAccessKey label = new LabelWithAccessKey(component);
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled")) {
            writer.startElement("span", component);
        } else {
            writer.startElement("a", component);
            writer.writeAttribute("href", (Object)href, null);
            if (onclick != null) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
            writer.writeAttribute("target", null, "target");
        }
        writer.writeComponentClass();
        writer.writeIdAttribute(clientId);
        writer.writeNameAttribute(clientId);
        writer.writeAttribute("title", null, "tip");
        writer.writeText((Object)"", null);
        String image = (String)component.getAttributes().get("image");
        if (image != null) {
            image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)image);
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)image, null);
            writer.writeAttribute("alt", (Object)"", null);
            writer.writeAttribute("border", (Object)"0", null);
            writer.endElement("img");
        }
        if (label.getText() != null) {
            if (image != null) {
                writer.writeText((Object)" ", null);
            }
            HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
        }
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
            }
            HtmlRendererUtil.addClickAcceleratorKey((FacesContext)facesContext, (String)clientId, (char)label.getAccessKey().charValue());
        }
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled")) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }
}

