/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UIMenuSelectOne;
import org.apache.myfaces.tobago.component.UIMenuSeparator;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.component.UISelectBooleanCommand;
import org.apache.myfaces.tobago.component.UISelectOneCommand;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class MenuBarRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(MenuBarRenderer.class);
    public static final String SEARCH_ID_POSTFIX = "::popup";
    private static final String MENU_ACCELERATOR_KEYS = "menuAcceleratorKeys";

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        String clientId;
        Map attributes = component.getAttributes();
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"menuPopup")) {
            clientId = component.getParent().getClientId(facesContext);
        } else {
            clientId = component.getClientId(facesContext);
            TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
            writer.startElement("div", component);
            writer.writeIdAttribute(clientId);
            String cssClasses = (String)attributes.get("styleClass");
            if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"pageMenu")) {
                cssClasses = cssClasses + "tobago-menuBar-page-facet";
            } else {
                writer.writeAttribute("style", null, "style");
            }
            writer.writeClassAttribute(cssClasses);
            writer.endElement("div");
        }
        attributes.put(MENU_ACCELERATOR_KEYS, new ArrayList());
        StringBuffer scriptBuffer = new StringBuffer();
        String setupFunction = this.createSetupFunction(facesContext, component, clientId, scriptBuffer);
        this.addScriptsAndStyles(facesContext, component, clientId, setupFunction, scriptBuffer.toString());
        List accKeyFunctions = (List)attributes.remove(MENU_ACCELERATOR_KEYS);
        if (!accKeyFunctions.isEmpty()) {
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, null, (String[])accKeyFunctions.toArray(new String[accKeyFunctions.size()]));
        }
    }

    private void renderTopLevelItems(FacesContext facesContext, TobagoResponseWriter writer, UIComponent component) throws IOException {
        String bac = "green;";
        for (Object o : component.getChildren()) {
            if (!(o instanceof UIMenu)) continue;
            writer.startElement("span");
            writer.writeAttribute("style", (Object)("position: relative; background: " + bac + ";"), null);
            this.writeMenuEntry(facesContext, writer, (UIPanel)((UIMenu)o));
            writer.endElement("span");
            bac = "lime";
        }
    }

    protected void addScriptsAndStyles(FacesContext facesContext, UIComponent component, String clientId, String setupFunction, String scriptBlock) throws IOException {
        UIPage page = ComponentUtil.findPage((UIComponent)component);
        page.getScriptFiles().add("script/tobago-menu.js");
        page.getStyleFiles().add("style/tobago-menu.css");
        String function = setupFunction + "('" + clientId + "', '" + page.getClientId(facesContext) + "');";
        if (TobagoConfig.getInstance((FacesContext)facesContext).isAjaxEnabled()) {
            HtmlRendererUtil.writeStyleLoader((FacesContext)facesContext, (String[])new String[]{"style/tobago-menu.css"});
            StringTokenizer st = new StringTokenizer(scriptBlock, "\n");
            ArrayList<String> lines = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
            lines.add(function);
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])new String[]{"script/tobago-menu.js"}, (String[])lines.toArray(new String[lines.size()]));
        } else {
            page.getScriptBlocks().add(scriptBlock);
            page.getOnloadScripts().add(function);
        }
    }

    protected String createSetupFunction(FacesContext facesContext, UIComponent component, String clientId, StringBuffer sb) throws IOException {
        String setupFunction = "setupMenu" + clientId.replaceAll(":", "_").replaceAll("\\.", "_").replaceAll("-", "_");
        sb.append("function ");
        sb.append(setupFunction);
        sb.append("(id, pageId) {\n");
        sb.append("  var menuStart = new Date();\n");
        sb.append("  var searchId = id + '::popup';\n");
        sb.append("  var menubar = document.getElementById(searchId);\n");
        sb.append("  if (! menubar) {\n");
        sb.append("    searchId  = id;\n");
        sb.append("    menubar = document.getElementById(searchId);\n");
        sb.append("  }\n");
        sb.append("  if (menubar) {\n");
        sb.append("    var menu = createMenuRoot(searchId);\n");
        sb.append("    menubar.menu = menu;\n");
        sb.append("    menu.setSubitemArrowImage(\"");
        sb.append(ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/MenuArrow.gif"));
        sb.append("\");\n");
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"menuPopup")) {
            this.addMenu(sb, "menu", facesContext, (UIPanel)component, 0);
            sb.append("    initMenuPopUp(searchId, pageId, \"");
            sb.append(component.getAttributes().get("menuPopupType"));
            sb.append("\");\n");
        } else {
            this.addMenuEntrys(sb, "menu", facesContext, component, true);
            sb.append("    initMenuBar(searchId, pageId);\n");
        }
        sb.append("  }\n");
        sb.append("  else {\n");
        sb.append("    LOG.debug('kein Element mit id: ' + searchId + ' gefunden!');\n");
        sb.append("  }\n");
        sb.append("  LOG.debug('Menu Total Time : ' + (new Date().getTime() - menuStart.getTime()));\n");
        sb.append("}\n");
        return setupFunction;
    }

    private int addMenu(StringBuffer sb, String var, FacesContext facesContext, UIPanel menu, int i) throws IOException {
        if (!menu.isRendered()) {
            return i;
        }
        String name = var + "_" + i++;
        sb.append("    var ").append(name).append(" = ").append(this.createMenuEntry(facesContext, menu)).append(";\n");
        sb.append("    ").append(var).append(".addMenuItem(").append(name).append(");\n");
        this.addMenuEntrys(sb, name, facesContext, (UIComponent)menu, false);
        return i;
    }

    private String createMenuEntry(FacesContext facesContext, UIPanel uiPanel) throws IOException {
        ResponseWriter savedWriter = facesContext.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        TobagoResponseWriter writer = (TobagoResponseWriter)savedWriter.cloneWithWriter((Writer)stringWriter);
        facesContext.setResponseWriter((ResponseWriter)writer);
        this.writeMenuEntry(facesContext, writer, uiPanel);
        facesContext.setResponseWriter(savedWriter);
        return "new Tobago.Menu.Item('" + this.removeLFs(stringWriter.toString()) + "', null)";
    }

    private void writeMenuEntry(FacesContext facesContext, TobagoResponseWriter writer, UIPanel uiPanel) throws IOException {
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)uiPanel, (String)"disabled");
        boolean topMenu = uiPanel.getParent().getRendererType() != null || ComponentUtil.getBooleanAttribute((UIComponent)uiPanel, (String)"menuPopup");
        boolean pageMenu = uiPanel.getParent().getRendererType() != null && ComponentUtil.getBooleanAttribute((UIComponent)uiPanel.getParent(), (String)"pageMenu");
        String spanClass = "tobago-menuBar-item-span tobago-menuBar-item-span-" + (disabled ? "disabled" : "enabled") + (topMenu ? " tobago-menuBar-item-span-top" : "") + (pageMenu ? " tobago-menuBar-item-page-top" : "");
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)uiPanel);
        String image = (String)uiPanel.getAttributes().get("image");
        this.addImage(writer, facesContext, image, disabled);
        writer.startElement("a", null);
        writer.writeClassAttribute(spanClass);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onfocus", (Object)"tobagoMenuFocus(event)", null);
        writer.writeAttribute("onblur", (Object)"tobagoMenuBlur(event)", null);
        writer.writeAttribute("onkeydown", (Object)"tobagoMenuKeyDown(event)", null);
        writer.writeAttribute("onkeypress", (Object)"tobagoMenuKeyPress(event)", null);
        if (label.getText() != null) {
            if (label.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
                }
                if (!disabled) {
                    writer.writeIdAttribute(uiPanel.getClientId(facesContext));
                    this.addAcceleratorKey(facesContext, (UIComponent)uiPanel, label.getAccessKey());
                }
            }
            HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("a");
    }

    private void addAcceleratorKey(FacesContext facesContext, UIComponent component, Character accessKey) {
        String clientId = component.getClientId(facesContext);
        while (component != null && !component.getAttributes().containsKey(MENU_ACCELERATOR_KEYS)) {
            component = component.getParent();
        }
        if (component != null) {
            List keys = (List)component.getAttributes().get(MENU_ACCELERATOR_KEYS);
            String jsStatement = HtmlRendererUtil.createOnclickAcceleratorKeyJsStatement((String)clientId, (char)accessKey.charValue(), null).toString();
            keys.add(jsStatement);
        } else {
            LOG.warn((Object)"Can't find menu root component!");
        }
    }

    private void addImage(TobagoResponseWriter writer, FacesContext facesContext, String image, boolean disabled) throws IOException {
        if (image != null) {
            String disabledImage = null;
            if (disabled) {
                disabledImage = ResourceManagerUtil.getDisabledImageWithPath((FacesContext)facesContext, (String)image);
            }
            image = disabledImage != null ? disabledImage : ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)image);
        } else {
            image = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/blank.gif");
        }
        writer.startElement("img", null);
        writer.writeClassAttribute("tobago-menu-item-image");
        writer.writeAttribute("src", (Object)image, null);
        writer.endElement("img");
    }

    private void addMenuEntrys(StringBuffer sb, String var, FacesContext facesContext, UIComponent component, boolean warn) throws IOException {
        int i = 0;
        for (Object o : component.getChildren()) {
            UIComponent entry = (UIComponent)o;
            if (entry instanceof UICommand) {
                this.addMenuEntry(sb, var, facesContext, (UICommand)entry);
                continue;
            }
            if (entry instanceof UIMenuSeparator) {
                this.addMenuSeparator(sb, var);
                continue;
            }
            if (entry instanceof UIMenu) {
                i = this.addMenu(sb, var, facesContext, (UIPanel)entry, i);
                continue;
            }
            if (!warn) continue;
            LOG.error((Object)("Illegal UIComponent class in menuBar: " + entry.getClass().getName()));
        }
    }

    private void addMenuEntry(StringBuffer sb, String var, FacesContext facesContext, UICommand command) throws IOException {
        String onClick = this.createOnClick(facesContext, (UIComponent)command);
        if (command instanceof UIMenuCommand) {
            this.addCommand(sb, var, facesContext, command, onClick);
        } else if (command instanceof UISelectBooleanCommand) {
            this.addSelectBoolean(sb, var, facesContext, command, onClick);
        } else if (command instanceof UISelectOneCommand) {
            this.addSelectOne(sb, var, facesContext, command, onClick);
        }
    }

    private String createOnClick(FacesContext facesContext, UIComponent component) {
        String clientId = component.getClientId(facesContext);
        String onclick = component.getAttributes().get("link") != null ? "Tobago.navigateToUrl('" + HtmlUtils.generateUrl((FacesContext)facesContext, (String)((String)component.getAttributes().get("link"))) + "');" : (component.getAttributes().get("onclick") != null ? (String)component.getAttributes().get("onclick") : "Tobago.submitAction('" + clientId + "');");
        return onclick;
    }

    private void addCommand(StringBuffer sb, String var, FacesContext facesContext, UICommand command, String onClick) throws IOException {
        String image = (String)command.getAttributes().get("image");
        this.addMenuItem(sb, var, facesContext, command, image, onClick);
    }

    private void addSelectBoolean(StringBuffer sb, String var, FacesContext facesContext, UICommand command, String onClick) throws IOException {
        UIComponent checkbox = command.getFacet("checkbox");
        if (checkbox == null) {
            checkbox = ComponentUtil.createUISelectBooleanFacet((FacesContext)facesContext, (UICommand)command);
            checkbox.setId(facesContext.getViewRoot().createUniqueId());
        }
        boolean checked = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"value");
        String clientId = checkbox.getClientId(facesContext);
        onClick = RenderUtil.addMenuCheckToggle((String)clientId, (String)onClick);
        if (checked) {
            sb.append("    menuCheckToggle('").append(clientId).append("');\n");
        }
        String image = checked ? "image/MenuCheckmark.gif" : null;
        this.addMenuItem(sb, var, facesContext, command, image, onClick);
    }

    private void addMenuItem(StringBuffer sb, String var, FacesContext facesContext, UICommand command, String image, String onClick) throws IOException {
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        onClick = CommandRendererBase.appendConfirmationScript((String)onClick, (UIComponent)command, (FacesContext)facesContext);
        this.addMenuItem(sb, var, facesContext, command, label, image, onClick);
    }

    private void addSelectOne(StringBuffer sb, String var, FacesContext facesContext, UICommand command, String onClick) throws IOException {
        Object value;
        onClick = CommandRendererBase.appendConfirmationScript((String)onClick, (UIComponent)command, (FacesContext)facesContext);
        List items = ComponentUtil.getSelectItems((UIComponent)command);
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        UIMenuSelectOne radio = (UIMenuSelectOne)command.getFacet("radio");
        if (radio == null) {
            radio = ComponentUtil.createUIMenuSelectOneFacet((FacesContext)facesContext, (UICommand)command);
            radio.setId(facesContext.getViewRoot().createUniqueId());
        }
        boolean markFirst = !ComponentUtil.hasSelectedValue((List)items, (Object)(value = radio.getValue()));
        String radioId = radio.getClientId(facesContext);
        String onClickPrefix = "menuSetRadioValue('" + radioId + "', '";
        String onClickPostfix = onClick != null ? "') ; " + onClick : "";
        for (SelectItem item : items) {
            String image;
            String labelText = item.getLabel();
            label.setAccessKey(null);
            if (labelText != null) {
                if (labelText.indexOf(95) > -1) {
                    label.setText(null);
                    label.setup(labelText);
                } else {
                    label.setText(labelText);
                }
            } else {
                LOG.warn((Object)("Menu item has label=null. UICommand.getClientId()=" + command.getClientId(facesContext)));
            }
            String formattedValue = MenuBarRenderer.getFormattedValue((FacesContext)facesContext, (UIComponent)command, (Object)item.getValue());
            onClick = onClickPrefix + formattedValue + onClickPostfix;
            if (item.getValue().equals(value) || markFirst) {
                image = "image/MenuRadioChecked.gif";
                markFirst = false;
                sb.append("    ").append(onClickPrefix).append(item.getValue()).append("');");
            } else {
                image = "image/MenuRadioUnchecked.gif";
            }
            this.addMenuItem(sb, var, facesContext, command, label, image, onClick);
        }
    }

    private void addMenuItem(StringBuffer sb, String var, FacesContext facesContext, UICommand command, LabelWithAccessKey label, String image, String onClick) throws IOException {
        if (!command.isRendered()) {
            return;
        }
        boolean disabled = ComponentUtil.getBooleanAttribute((UIComponent)command, (String)"disabled");
        String spanClass = "tobago-menuBar-item-span tobago-menuBar-item-span-" + (disabled ? "disabled" : "enabled");
        ResponseWriter savedWriter = facesContext.getResponseWriter();
        StringWriter stringWriter = new StringWriter();
        TobagoResponseWriter writer = (TobagoResponseWriter)savedWriter.cloneWithWriter((Writer)stringWriter);
        facesContext.setResponseWriter((ResponseWriter)writer);
        this.addImage(writer, facesContext, image, disabled);
        writer.startElement("a", null);
        writer.writeClassAttribute(spanClass);
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info((Object)("dublicated accessKey : " + label.getAccessKey()));
            }
            if (!disabled) {
                writer.writeIdAttribute(command.getClientId(facesContext));
                this.addAcceleratorKey(facesContext, (UIComponent)command, label.getAccessKey());
            }
        }
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onfocus", (Object)"tobagoMenuFocus(event)", null);
        writer.writeAttribute("onblur", (Object)"tobagoMenuBlur(event)", null);
        writer.writeAttribute("onkeydown", (Object)"tobagoMenuKeyDown(event)", null);
        writer.writeAttribute("onkeypress", (Object)"tobagoMenuKeyPress(event)", null);
        if (label.getText() != null) {
            HtmlRendererUtil.writeLabelWithAccessKey((ResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("a");
        facesContext.setResponseWriter(savedWriter);
        String html = stringWriter.toString();
        sb.append("    ");
        sb.append(var);
        sb.append(".addMenuItem(new Tobago.Menu.Item('");
        sb.append(this.removeLFs(html));
        sb.append("', ");
        if (!disabled) {
            sb.append("\"");
            sb.append(onClick);
            sb.append("\"");
        } else {
            sb.append("null");
        }
        sb.append(", ");
        sb.append(disabled ? "true" : "false");
        sb.append("));\n");
    }

    private void addMenuSeparator(StringBuffer sb, String var) {
        String html = "<div style=\"text-align: center;\"><hr class=\"tobago-menuBar-separator\"></div>";
        sb.append("    ");
        sb.append(var);
        sb.append(".addMenuItem(new Tobago.Menu.Item('");
        sb.append(this.removeLFs(html));
        sb.append("', ");
        sb.append("null");
        sb.append(", ");
        sb.append("true");
        sb.append("));\n");
    }

    private String removeLFs(String s) {
        return s.replaceAll("\n", " ");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

