/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.MessageRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class MessageRenderer
extends MessageRendererBase {
    private static final Log LOG = LogFactory.getLog(MessageRenderer.class);

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("component = '" + component + "'"));
        }
        String clientId = null;
        if (component instanceof UIMessage) {
            clientId = ((UIMessage)component).getFor();
        }
        int count = 0;
        Iterator i = facesContext.getMessages(clientId);
        while (i.hasNext()) {
            ++count;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("here are " + count + " messages"));
        }
        return count * this.getConfiguredValue(facesContext, component, "messageHeight");
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIMessage component = (UIMessage)uiComponent;
        String clientId = ComponentUtil.findClientIdFor((UIComponent)component, (FacesContext)facesContext);
        Iterator iterator = facesContext.getMessages(clientId);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)component);
        writer.writeClassAttribute("tobago-validation-message");
        writer.writeAttribute("style", null, "style");
        while (iterator.hasNext()) {
            FacesMessage message = (FacesMessage)iterator.next();
            writer.startElement("label", null);
            writer.writeAttribute("for", (Object)clientId, null);
            writer.writeAttribute("title", (Object)message.getDetail(), null);
            writer.writeText((Object)message.getSummary(), null);
            writer.endElement("label");
            writer.startElement("br", null);
            writer.endElement("br");
        }
        writer.endElement("span");
    }
}

