/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.MessageRendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class MessagesRenderer
extends MessageRendererBase {
    private static final Log LOG = LogFactory.getLog(MessagesRenderer.class);

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int count = 0;
        Iterator i = facesContext.getMessages();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("component = '" + component + "'"));
            LOG.debug((Object)("here are " + count + " messages"));
        }
        return count > 0 ? count * this.getConfiguredValue(facesContext, component, "messageHeight") : this.getConfiguredValue(facesContext, component, "fixedHeight");
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("facesContect is " + facesContext.getClass().getName()));
        }
        if (facesContext.getMessages().hasNext()) {
            writer.startElement("span", component);
            writer.writeClassAttribute("tobago-validation-message");
            writer.writeAttribute("style", null, "style");
            String focusId = null;
            Iterator clientIds = facesContext.getClientIdsWithMessages();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                this.encodeMessagesForId(facesContext, (ResponseWriter)writer, clientId);
                if (focusId != null) continue;
                focusId = clientId;
            }
            if (focusId != null) {
                ComponentUtil.findPage((UIComponent)component).setFocusId(focusId);
            }
            writer.endElement("span");
        }
    }

    private void encodeMessagesForId(FacesContext facesContext, ResponseWriter writer, String clientId) throws IOException {
        Iterator iterator = facesContext.getMessages(clientId);
        while (iterator.hasNext()) {
            FacesMessage message = (FacesMessage)iterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("message = " + message.getSummary()));
            }
            this.encodeMessage(writer, message, clientId);
        }
    }

    private void encodeMessage(ResponseWriter writer, FacesMessage message, String clientId) throws IOException {
        writer.startElement("label", null);
        if (clientId != null) {
            writer.writeAttribute("for", (Object)clientId, null);
        }
        writer.writeAttribute("title", (Object)message.getDetail(), null);
        writer.writeText((Object)message.getSummary(), null);
        writer.endElement("label");
        writer.startElement("br", null);
        writer.endElement("br");
    }
}

