/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.UILayout;
import org.apache.myfaces.tobago.component.UIPage;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.PageRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.util.AccessKeyMap;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRenderer
extends PageRendererBase {
    private static final Log LOG = LogFactory.getLog(PageRenderer.class);
    private static final String LOOSE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">";
    private static final String STRICT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String FRAMESET = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">";

    public void encodeEndTobago(FacesContext facesContext, UIComponent component) throws IOException {
        UIPage page = (UIPage)component;
        HtmlRendererUtil.prepareRender((FacesContext)facesContext, (UIComponent)page);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        StringWriter content = new StringWriter();
        ResponseWriter contentWriter = writer.cloneWithWriter((Writer)content);
        facesContext.setResponseWriter(contentWriter);
        UIComponent menubar = page.getFacet("menuBar");
        if (menubar != null) {
            menubar.getAttributes().put("pageMenu", Boolean.TRUE);
            page.getOnloadScripts().add("Tobago.setElementWidth('" + menubar.getClientId(facesContext) + "', Tobago.getBrowserInnerWidth())");
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)menubar);
        }
        UILayout.getLayout((UIComponent)component).encodeChildrenOfComponent(facesContext, component);
        StringWriter popups = new StringWriter();
        contentWriter = writer.cloneWithWriter((Writer)popups);
        facesContext.setResponseWriter(contentWriter);
        for (int i = 0; i < page.getPopups().size(); ++i) {
            UIComponent popup = (UIComponent)page.getPopups().get(i);
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)popup);
        }
        facesContext.setResponseWriter((ResponseWriter)writer);
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 1L);
        if (LOG.isDebugEnabled()) {
            Iterator i$ = page.getAttributes().entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = i$.next();
                LOG.debug((Object)("*** '" + entry.getKey() + "' -> '" + entry.getValue() + "'"));
            }
        }
        Application application = facesContext.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        String formAction = viewHandler.getActionURL(facesContext, viewId);
        String charset = (String)page.getAttributes().get("charset");
        String title = (String)page.getAttributes().get("label");
        String doctype = this.generateDoctype(page);
        if (doctype != null) {
            writer.write(doctype);
            writer.write(10);
        }
        writer.startElement("html", null);
        writer.startElement("head", null);
        HtmlRendererUtil.writeJavascript((ResponseWriter)writer, (String)"var TbgHeadStart = new Date();");
        response.setContentType(this.generateContentType(facesContext, charset));
        writer.startElement("title", null);
        writer.writeText((Object)(title != null ? title : ""), null);
        writer.endElement("title");
        for (String styleFile : page.getStyleFiles()) {
            List styles = ResourceManagerUtil.getStyles((FacesContext)facesContext, (String)styleFile);
            for (String styleString : styles) {
                if (styleString.length() <= 0) continue;
                writer.startElement("link", null);
                writer.writeAttribute("rel", (Object)"stylesheet", null);
                writer.writeAttribute("href", (Object)styleString, null);
                writer.writeAttribute("media", (Object)"screen", null);
                writer.writeAttribute("type", (Object)"text/css", null);
                writer.endElement("link");
            }
        }
        Set styleBlocks = page.getStyleBlocks();
        if (styleBlocks.size() > 0) {
            writer.startElement("style", null);
            for (String cssBlock : styleBlocks) {
                writer.write(cssBlock);
            }
            writer.endElement("style");
        }
        List scriptFiles = page.getScriptFiles();
        this.addScripts((ResponseWriter)writer, facesContext, "script/prototype.js");
        this.addScripts((ResponseWriter)writer, facesContext, "script/tobago.js");
        this.addScripts((ResponseWriter)writer, facesContext, "script/theme-config.js");
        scriptFiles.remove("script/prototype.js");
        scriptFiles.remove("script/tobago.js");
        scriptFiles.remove("script/theme-config.js");
        boolean hideClientLogging = true;
        boolean debugMode = ClientProperties.getInstance((UIViewRoot)facesContext.getViewRoot()).isDebugMode();
        if (debugMode) {
            scriptFiles.add("script/effects.js");
            scriptFiles.add("script/dragdrop.js");
            scriptFiles.add("script/logging.js");
        }
        for (String scriptFile : scriptFiles) {
            this.addScripts((ResponseWriter)writer, facesContext, scriptFile);
        }
        String focusId = page.getFocusId();
        if (focusId != null) {
            HtmlRendererUtil.writeJavascript((ResponseWriter)writer, (String)("Tobago.focusId = '" + focusId + "';"));
        }
        HtmlRendererUtil.startJavascript((ResponseWriter)writer);
        this.writeEventFunction(writer, page.getOnloadScripts(), "load");
        this.writeEventFunction(writer, page.getOnunloadScripts(), "unload");
        this.writeEventFunction(writer, page.getOnexitScripts(), "exit");
        int debugCounter = 0;
        for (String script : page.getScriptBlocks()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("write scriptblock " + ++debugCounter + " :\n" + script));
            }
            writer.write(script);
            writer.write(10);
        }
        String clientId = page.getClientId(facesContext);
        HtmlRendererUtil.endJavascript((ResponseWriter)writer);
        String defaultActionId = page.getDefaultActionId() != null ? page.getDefaultActionId() : "";
        writer.endElement("head");
        writer.startElement("body", (UIComponent)page);
        writer.writeAttribute("onload", (Object)("Tobago.init('" + clientId + "');"), null);
        writer.writeAttribute("scroll", (Object)"auto", null);
        writer.writeComponentClass();
        writer.writeIdAttribute(clientId);
        if (debugMode) {
            String[] jsFiles = new String[]{"script/effects.js", "script/dragdrop.js", "script/logging.js"};
            String[] jsCommand = new String[]{"new LOG.LogArea({hide: " + hideClientLogging + "});"};
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, (String[])jsFiles, (String[])jsCommand);
        }
        HtmlRendererUtil.writeJavascript((ResponseWriter)writer, (String)"TbgTimer.startBody = new Date();");
        writer.startElement("form", (UIComponent)page);
        writer.writeNameAttribute(clientId + "::" + "form");
        writer.writeAttribute("action", (Object)formAction, null);
        writer.writeIdAttribute(page.getFormId(facesContext));
        writer.writeAttribute("method", (Object)this.getMethod(page), null);
        writer.writeAttribute("enctype", null, "enctype");
        writer.writeAttribute("accept-charset", (Object)"utf-8", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeNameAttribute(clientId + "::" + "form-action");
        writer.writeIdAttribute(clientId + "::" + "form-action");
        writer.writeAttribute("value", (Object)defaultActionId, null);
        writer.endElement("input");
        writer.write(content.toString());
        writer.write(popups.toString());
        writer.endElement("form");
        if (debugMode) {
            ArrayList<String> logMessages = new ArrayList<String>();
            Iterator ids = facesContext.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                Iterator messages = facesContext.getMessages(id);
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    logMessages.add(this.errorMessageForDebugging(id, message));
                }
            }
            if (!logMessages.isEmpty()) {
                logMessages.add(0, "LOG.show();");
            }
            logMessages.add("LOG.info(\"FacesContext = " + facesContext + "\");");
            HtmlRendererUtil.writeScriptLoader((FacesContext)facesContext, null, (String[])logMessages.toArray(new String[logMessages.size()]));
        }
        HtmlRendererUtil.writeJavascript((ResponseWriter)writer, (String)"TbgTimer.endBody = new Date();");
        writer.endElement("body");
        writer.endElement("html");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("unused AccessKeys    : " + AccessKeyMap.getUnusedKeys((FacesContext)facesContext)));
            LOG.debug((Object)("dublicated AccessKeys: " + AccessKeyMap.getDublicatedKeys((FacesContext)facesContext)));
        }
    }

    private void writeEventFunction(TobagoResponseWriter writer, Set<String> eventFunctions, String event) throws IOException {
        if (!eventFunctions.isEmpty()) {
            writer.write("Tobago.applicationOn" + event + " = function() {\n  ");
            for (String function : eventFunctions) {
                writer.write(function);
                if (!function.trim().endsWith(";")) {
                    writer.write(";\n  ");
                    continue;
                }
                writer.write("\n  ");
            }
            writer.write("\n}\n");
        }
    }

    private void addScripts(ResponseWriter writer, FacesContext facesContext, String script) throws IOException {
        List<String> scripts;
        String ucScript = script.toUpperCase();
        if (ucScript.startsWith("HTTP:") || ucScript.startsWith("FTP:") || ucScript.startsWith("/")) {
            scripts = new ArrayList<String>();
            scripts.add(script);
        } else {
            scripts = ResourceManagerUtil.getScripts((FacesContext)facesContext, (String)script);
        }
        for (String scriptString : scripts) {
            if (scriptString.length() <= 0) continue;
            writer.startElement("script", null);
            writer.writeAttribute("src", (Object)scriptString, null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.endElement("script");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    private void errorMessageForDebugging(String id, FacesMessage message, ResponseWriter writer) throws IOException {
        writer.startElement("div", null);
        writer.writeAttribute("style", (Object)"color: red", null);
        writer.write("[");
        writer.write(id != null ? id : "null");
        writer.write("]");
        writer.write("[");
        writer.write(message.getSummary() == null ? "null" : message.getSummary());
        writer.write("/");
        writer.write(message.getDetail() == null ? "null" : message.getDetail());
        writer.write("]");
        writer.endElement("div");
        writer.startElement("br", null);
        writer.endElement("br");
    }

    private String errorMessageForDebugging(String id, FacesMessage message) {
        StringBuffer sb = new StringBuffer("LOG.info(\"FacesMessage: [");
        sb.append(id != null ? id : "null");
        sb.append("][");
        sb.append(message.getSummary() == null ? "null" : message.getSummary().replace("\\", "\\\\").replace("\"", "\\\""));
        sb.append("/");
        sb.append(message.getDetail() == null ? "null" : message.getDetail().replace("\\", "\\\\").replace("\"", "\\\""));
        sb.append("]\");");
        return sb.toString();
    }

    private String getMethod(UIPage page) {
        String method = (String)page.getAttributes().get("method");
        return method == null ? "post" : method;
    }

    private String generateDoctype(UIPage page) {
        String doctype = (String)page.getAttributes().get("doctype");
        String type = null;
        if (doctype == null || "loose".equals(doctype)) {
            type = LOOSE;
        } else if ("strict".equals(doctype)) {
            type = STRICT;
        } else if ("frameset".equals(doctype)) {
            type = FRAMESET;
        } else {
            LOG.warn((Object)("Unsupported DOCTYPE keyword :'" + doctype + "'"));
        }
        return type;
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String generateContentType(FacesContext facesContext, String charset) {
        StringBuffer sb = new StringBuffer("text/");
        ClientProperties clientProperties = ClientProperties.getInstance((UIViewRoot)facesContext.getViewRoot());
        sb.append(clientProperties.getContentType());
        if (charset == null) {
            charset = "UTF-8";
        }
        sb.append("; charset=");
        sb.append(charset);
        return sb.toString();
    }
}

