/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPanel;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;

public class PanelRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(PanelRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public int getFixedHeight(FacesContext facesContext, UIComponent component) {
        int height = ComponentUtil.getIntAttribute((UIComponent)component, (String)"height", (int)-1);
        if (height == -1) {
            height = PanelRenderer.getFixedHeightForPanel(component, facesContext);
        }
        return height;
    }

    public static int getFixedHeightForPanel(UIComponent component, FacesContext facesContext) {
        int height = -1;
        UIComponent layout = component.getFacet("layout");
        if (layout != null) {
            RendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)layout);
            height = renderer.getFixedHeight(facesContext, component);
        }
        if (height < 0) {
            if (component.getChildren().size() == 0) {
                height = 0;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Can't calculate fixedHeight! using estimation by contained components. for " + component.getClientId(facesContext) + " = " + component.getClass().getName() + " " + component.getRendererType()));
                }
                height = 0;
                for (UIComponent child : component.getChildren()) {
                    int h;
                    RendererBase renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)child);
                    if (renderer == null && child instanceof UINamingContainer && child.getChildren().size() > 0) {
                        renderer = ComponentUtil.getRenderer((FacesContext)facesContext, (UIComponent)((UIComponent)child.getChildren().get(0)));
                    }
                    if (renderer == null || (h = renderer.getFixedHeight(facesContext, child)) <= 0) continue;
                    height += h;
                }
            }
        }
        return height;
    }

    public void encodeChildrenTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIPanel component = (UIPanel)uiComponent;
        for (UIComponent child : component.getChildren()) {
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)child);
        }
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }
}

