/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class PopupRenderer
extends RendererBase {
    private static final Log LOG = LogFactory.getLog(PopupRenderer.class);
    public static final String CONTENT_ID_POSTFIX = "::content";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBeginTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        UIPopup component = (UIPopup)uiComponent;
        String clientId = component.getClientId(facesContext);
        String contentDivId = clientId + CONTENT_ID_POSTFIX;
        String left = component.getLeft();
        String top = component.getTop();
        StringBuffer contentStyle = new StringBuffer();
        if (component.getWidth() != null) {
            contentStyle.append("width: ");
            contentStyle.append(component.getWidth());
            contentStyle.append("; ");
        }
        if (component.getHeight() != null) {
            contentStyle.append("height: ");
            contentStyle.append(component.getHeight());
            contentStyle.append("; ");
        }
        contentStyle.append("left: ");
        contentStyle.append(left != null ? left : "100");
        contentStyle.append("; ");
        contentStyle.append("top: ");
        contentStyle.append(top != null ? top : "50");
        contentStyle.append("; ");
        writer.startElement("div", (UIComponent)component);
        writer.writeIdAttribute(clientId);
        writer.writeComponentClass();
        writer.writeAttribute("onclick", (Object)("Tobago.popupBlink('" + clientId + "')"), null);
        if (ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie()) {
            String bgImage = ResourceManagerUtil.getImageWithPath((FacesContext)facesContext, (String)"image/popupBg.png");
            writer.writeAttribute("style", (Object)("background: none; filter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + bgImage + "', sizingMethod='scale');"), null);
        }
        writer.endElement("div");
        if (ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie()) {
            writer.startElement("iframe", (UIComponent)component);
            writer.writeIdAttribute(clientId + "::" + "iframe");
            writer.writeClassAttribute("tobago-popup-iframe");
            writer.writeAttribute("style", (Object)contentStyle.toString(), null);
            writer.endElement("iframe");
        }
        writer.startElement("div", (UIComponent)component);
        writer.writeIdAttribute(contentDivId);
        writer.writeClassAttribute("tobago-popup-content");
        writer.writeAttribute("style", (Object)contentStyle.toString(), null);
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIPopup component = (UIPopup)uiComponent;
        String clientId = component.getClientId(facesContext);
        writer.endElement("div");
        String setupScript = "Tobago.setupPopup('" + clientId + "', '" + component.getLeft() + "', '" + component.getTop() + "');";
        HtmlRendererUtil.writeJavascript((ResponseWriter)writer, (String)setupScript);
        if (ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"popupReset")) {
            component.setRendered(false);
        }
    }
}

