/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.html.HtmlRendererUtil;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class RichTextEditorRenderer
extends InputRendererBase {
    private static final Log LOG = LogFactory.getLog(RichTextEditorRenderer.class);
    public static final String CHANGE_BUTTON = "togleState";

    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        super.decode(facesContext, component);
        String actionId = ComponentUtil.findPage((UIComponent)component).getActionId();
        if (actionId != null && actionId.equals(component.getClientId(facesContext) + CHANGE_BUTTON)) {
            boolean state = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"state_preview");
            component.getAttributes().put("state_preview", !state);
            facesContext.renderResponse();
        }
        ((EditableValueHolder)component).setValid(true);
    }

    public static String contentToHtml(String content) {
        try {
            LOG.warn((Object)"richtext switched off, because of dependencies");
            return content;
        }
        catch (Exception e) {
            LOG.error((Object)"failed to parser wiki markup", (Throwable)e);
            return content;
        }
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIInput component = (UIInput)uiComponent;
        HtmlRendererUtil.createHeaderAndBodyStyles((FacesContext)facesContext, (UIComponent)component);
        boolean previewState = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"state_preview");
        String clientId = component.getClientId(facesContext);
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        String classes = (String)component.getAttributes().get("styleClass");
        writer.startElement("div", (UIComponent)component);
        writer.writeClassAttribute(classes + " tobago-richTextEditor-container");
        writer.writeAttribute("style", null, "style");
        UIComponent toolbar = component.getFacet("toolBar");
        if (toolbar == null) {
            toolbar = this.createToolbar(facesContext, component);
        }
        facesContext.getExternalContext().getRequestMap().put("tobagoRichtextPreviewState", previewState ? Boolean.TRUE : Boolean.FALSE);
        RenderUtil.encode((FacesContext)facesContext, (UIComponent)toolbar);
        String content = this.getCurrentValue(facesContext, (UIComponent)component);
        if (previewState) {
            writer.startElement("input", (UIComponent)component);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeNameAttribute(clientId);
            writer.writeAttribute("value", (Object)content, null);
            writer.endElement("input");
            writer.startElement("div", (UIComponent)component);
            writer.writeClassAttribute(classes + " tobago-richTextEditor-body");
            writer.writeIdAttribute(clientId);
            writer.writeAttribute("style", null, "style_body");
            writer.write(RichTextEditorRenderer.contentToHtml(content));
            writer.endElement("div");
        } else {
            writer.startElement("textarea", (UIComponent)component);
            writer.writeClassAttribute(classes + " tobago-richTextEditor-body");
            writer.writeNameAttribute(clientId);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute("style", null, "style_body");
            String onchange = HtmlUtils.generateOnchange((UIInput)component, (FacesContext)facesContext);
            if (null != onchange) {
                writer.writeAttribute("onchange", (Object)onchange, null);
            }
            if (content != null) {
                writer.writeText((Object)content, null);
            }
            writer.endElement("textarea");
        }
        writer.endElement("div");
    }

    private UIComponent createToolbar(FacesContext facesContext, UIInput component) {
        UIPanel toolbar = (UIPanel)ComponentUtil.createComponent((FacesContext)facesContext, (String)"javax.faces.Panel", (String)"ToolBar");
        String clientId = component.getClientId(facesContext);
        component.getFacets().put("toolBar", toolbar);
        toolbar.getAttributes().put("iconSize", "small");
        toolbar.getAttributes().put("labelPosition", "off");
        UICommand command = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.SelectBooleanCommand", (String)"MenuCommand");
        toolbar.getChildren().add(command);
        command.getAttributes().put("image", "image/tobago-richtext-edit.gif");
        command.setValueBinding("disabled", ComponentUtil.createValueBinding((String)"#{! tobagoRichtextPreviewState}"));
        command.setValueBinding("value", ComponentUtil.createValueBinding((String)"#{!tobagoRichtextPreviewState}"));
        String title = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.richtexteditor.edit.title");
        command.getAttributes().put("tip", title);
        String onClick = "Tobago.submitAction('" + clientId + CHANGE_BUTTON + "')";
        command.getAttributes().put("onclick", onClick);
        command = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.SelectBooleanCommand", (String)"MenuCommand");
        toolbar.getChildren().add(command);
        command.getAttributes().put("image", "image/tobago-richtext-preview.gif");
        command.setValueBinding("disabled", ComponentUtil.createValueBinding((String)"#{tobagoRichtextPreviewState}"));
        command.setValueBinding("value", ComponentUtil.createValueBinding((String)"#{tobagoRichtextPreviewState}"));
        title = ResourceManagerUtil.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.richtexteditor.preview.title");
        command.getAttributes().put("tip", title);
        command.getAttributes().put("onclick", onClick);
        command = (UICommand)ComponentUtil.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", (String)"MenuCommand");
        toolbar.getChildren().add(command);
        command.getAttributes().put("image", "image/config.gif");
        command.getAttributes().put("onclick", "Tobago.doEditorCommand(this);");
        return toolbar;
    }
}

