/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.RenderUtil;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectBooleanCheckboxRenderer
extends RendererBase {
    public void decode(FacesContext facesContext, UIComponent component) {
        if (ComponentUtil.isOutputOnly((UIComponent)component)) {
            return;
        }
        UIInput uiInput = (UIInput)component;
        String newValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(uiInput.getClientId(facesContext));
        if (newValue != null && (newValue.equalsIgnoreCase("on") || newValue.equalsIgnoreCase("yes") || newValue.equalsIgnoreCase("true"))) {
            uiInput.setSubmittedValue((Object)Boolean.TRUE);
        } else {
            uiInput.setSubmittedValue((Object)Boolean.FALSE);
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        return super.getConvertedValue(facesContext, component, submittedValue);
    }

    public void encodeEndTobago(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Boolean currentValue;
        UISelectBoolean component = (UISelectBoolean)uiComponent;
        TobagoResponseWriter writer = (TobagoResponseWriter)facesContext.getResponseWriter();
        UIComponent label = ComponentUtil.provideLabel((FacesContext)facesContext, (UIComponent)component);
        boolean inline = ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"inline");
        if (label != null && !inline) {
            writer.startElement("table", (UIComponent)component);
            writer.writeAttribute("border", (Object)"0", null);
            writer.writeAttribute("cellspacing", (Object)"0", null);
            writer.writeAttribute("cellpadding", (Object)"0", null);
            writer.writeAttribute("summary", (Object)"", null);
            writer.writeAttribute("title", null, "tip");
            writer.startElement("tr", null);
            writer.startElement("td", null);
        }
        boolean checked = (currentValue = (Boolean)component.getValue()) != null && currentValue != false;
        writer.startElement("input", (UIComponent)component);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)"true", null);
        writer.writeAttribute("checked", checked);
        writer.writeNameAttribute(component.getClientId(facesContext));
        writer.writeComponentClass();
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeAttribute("disabled", ComponentUtil.getBooleanAttribute((UIComponent)component, (String)"disabled"));
        writer.writeAttribute("title", null, "tip");
        writer.endElement("input");
        if (label != null && !inline) {
            writer.endElement("td");
            writer.startElement("td", null);
            writer.writeText((Object)"", null);
        }
        if (label != null) {
            RenderUtil.encode((FacesContext)facesContext, (UIComponent)label);
        }
        if (label != null && !inline) {
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("table");
        }
    }
}

